package org.jboss.jsr299.tck.tests.inheritance.specialization.producer.method;

import static org.jboss.jsr299.tck.impl.util.Reflections.annotationSetMatches;

import java.lang.annotation.Annotation;

import javax.inject.AnnotationLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class ProducerMethodSpecializationTest extends AbstractDeclarativeTest
{
   
   private static Annotation EXPENSIVE_LITERAL = new AnnotationLiteral<Expensive>() {};

   @Test
   @SpecAssertions({
     @SpecAssertion(section = "4.3.1", id = "c"),
     @SpecAssertion(section = "3.4.5", id = "a")
   })
   public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean()
   {
      assert getCurrentManager().resolveByType(Product.class, EXPENSIVE_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(Product.class, EXPENSIVE_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches( getCurrentManager().resolveByType(Product.class, EXPENSIVE_LITERAL).iterator().next().getBindings(), Expensive.class, Sparkly.class);
   }
   
   @Test
   @SpecAssertions({
     @SpecAssertion(section = "4.3.1", id = "d"),
     @SpecAssertion(section = "3.4.5", id = "a")
   })
   public void testSpecializingBeanHasNameOfSpecializedBean()
   {
      assert getCurrentManager().resolveByType(Product.class, new AnnotationLiteral<Sparkly>(){}).size() == 1;
      assert getCurrentManager().resolveByType(Product.class, new AnnotationLiteral<Sparkly>(){}).iterator().next().getName().equals("expensiveGift");
   }
   
   @Test
   @SpecAssertions({
     @SpecAssertion(section = "4.3.1", id = "f"),
     @SpecAssertion(section = "3.4.5", id = "a")
   })
   public void testSpecializedBeanNotInstantiated() throws Exception
   {
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            Product product = getCurrentManager().getInstanceByType(Product.class, EXPENSIVE_LITERAL);
            assert product instanceof Necklace;
         }
         
      }.run();
   }

}
