package org.jboss.jsr299.tck.tests.inheritance.specialization.simple;

import static org.jboss.jsr299.tck.impl.util.Reflections.annotationSetMatches;

import java.lang.annotation.Annotation;

import javax.inject.AnnotationLiteral;
import javax.inject.DefinitionException;
import javax.inject.InconsistentSpecializationException;

import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class SimpleBeanSpecializationTest extends AbstractDeclarativeTest
{

   private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>()
   {
   };

   @SuppressWarnings("unchecked")
   @Test
   @SpecAssertions( { @SpecAssertion(section = "4.3.1", id = "c"), @SpecAssertion(section = "3.2.7", id = "a") })
   public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean()
   {
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getTypes().contains(LazyFarmer.class);
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches(getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getBindings(), Landowner.class, Lazy.class);
   }

   @Test
   @SpecAssertions( { @SpecAssertion(section = "4.3.1", id = "d"), @SpecAssertion(section = "3.2.7", id = "a") })
   public void testSpecializingBeanHasNameOfSpecializedBean()
   {
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getTypes().contains(LazyFarmer.class);
      assert getCurrentManager().resolveByType(Farmer.class, LANDOWNER_LITERAL).iterator().next().getName().equals("farmer");
   }

   @Test
   @SpecAssertions( { @SpecAssertion(section = "4.3.1", id = "f"), @SpecAssertion(section = "3.2.7", id = "b") })
   public void testSpecializedBeanNotInstantiated() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            Farmer farmer = getCurrentManager().getInstanceByType(Farmer.class, LANDOWNER_LITERAL);
            assert farmer.getClassName().equals(LazyFarmer.class.getName());
         }

      }.run();
   }

   @Test
   @SpecAssertion(section = "4.3.1", id = "g")
   public void testProducerMethodOnSpecializedBeanCalledOnSpecializingBean() throws Exception
   {
//      deployBeans(Office.class, Building.class);
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByType(Waste.class).size() == 1;
            assert getCurrentManager().getInstanceByType(Waste.class).getFrom().equals(Office.class.getName());
         }

      }.run();
   }

}
