/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.lookup.byname.duplicateNameResolution;

import javax.inject.AmbiguousDependencyException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: Public Release Draft 2
 * 
 */
@Artifact
public class DuplicateNameResolutionTest extends AbstractDeclarativeTest
{
   /**
    * Otherwise, if resolveByName() returned more than one Web Bean, throw an
    * AmbiguousDependencyException.
    * 
    * @throws Exception
    */
   @Test(groups = { "resolution", "el" }, expectedExceptions = AmbiguousDependencyException.class)
   @SpecAssertion(section = "5.10", id = "e")
   public void testDuplicateNamedBeans() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByName("whitefish").size() == 2;
            getCurrentManager().getInstanceByName("whitefish");
         }

      }.run();
   }

}
