package org.jboss.jsr299.tck.tests.lookup.nonContextual;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.jboss.jsr299.tck.impl.packaging.Packaging;
import org.jboss.jsr299.tck.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
@IntegrationTest
@Packaging(PackagingType.EAR)
public class NonContextualInjectionTest extends AbstractDeclarativeTest
{

   @Test(groups = { "integration", "stub" })
   @SpecAssertion(section = "5.12.1", id = "a")
   public void testInjectionIntoSessionBeanLookedUpInJndi() throws Exception
   {
      // Quite tough as no universal names. Need to allow these to be specified or something...
      assert false;
   }
   
   @Test(groups = { "integration" })
   @SpecAssertion(section = "5.12.1", id = "a")
   public void testInjectionIntoSessionBeanInjectedViaEjb() throws Exception
   {
      assert getCurrentManager().resolveByType(VillageLocal.class).size() == 1;
      assert getCurrentManager().getInstanceByType(VillageLocal.class).getFarm().getBarn() != null;
   }
   
   @Test(groups = { "integration", "broken" })
   @SpecAssertion(section = "5.12.1", id = "a")
   public void testInjectionIntoSessionBeanInjectedViaResource() throws Exception
   {
      // Quite tough as no universal names. Need to allow these to be specified or something...
      assert getCurrentManager().resolveByType(HamletLocal.class).size() == 1;
      assert getCurrentManager().getInstanceByType(HamletLocal.class).getFarm().getBarn() != null;
   }
   
   @Test(groups = { "stub", "integration" })
   @SpecAssertion(section = "5.12.2", id = "a")
   public void testInjectionIntoMessageDrivenBean()
   {
      assert false;
   }


}
