package org.jboss.jsr299.tck.tests.context;

import javax.context.ApplicationScoped;
import javax.context.Context;
import javax.context.SessionScoped;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class DestroyedInstanceReturnedByGetTest extends AbstractJSR299Test
{
   

   Context context;

   @Override
   public void beforeMethod()
   {
      super.beforeMethod();
      if (context == null)
      {
         context = new DummyContext();
         getCurrentManager().addContext(context);
      }
   }
 
   @Test(groups = { "contexts", "ri-broken" })
   @SpecAssertion(section = "8.1", id = "g")
   public void testDestroyedInstanceMustNotBeReturnedByGet()
   {
      Bean<MySessionBean> mySessionBean = getCurrentManager().resolveByType(MySessionBean.class).iterator().next();
      MyCreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      MySessionBean beanInstance = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, myCreationalContext);
      assert beanInstance != null;
      mySessionBean.destroy(beanInstance);
      MySessionBean beanInstanceFromGet = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean);
      assert beanInstanceFromGet != beanInstance;
      
      Bean<MyApplicationBean> myApplicationBean = getCurrentManager().resolveByType(MyApplicationBean.class).iterator().next();
      MyCreationalContext<MyApplicationBean> myCreationalContextForApplication = new MyCreationalContext<MyApplicationBean>();
      MyApplicationBean myApplicationBeanInstance = getCurrentManager().getContext(ApplicationScoped.class).get(myApplicationBean, myCreationalContextForApplication);
      assert myApplicationBeanInstance != null;
      myApplicationBean.destroy(myApplicationBeanInstance);
      
      MyApplicationBean mySecondApplicationBeanInstance = getCurrentManager().getContext(ApplicationScoped.class).get(myApplicationBean);
      assert mySecondApplicationBeanInstance != null;
      assert myApplicationBeanInstance != mySecondApplicationBeanInstance;
   }
   
}
