package org.jboss.jsr299.tck.tests.context;

import javax.context.Context;
import javax.context.Contextual;
import javax.context.SessionScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class GetWithNoCreationalContextTest extends AbstractJSR299Test
{
   
   Context context;

   public void initContext()
   {
      if (context == null)
      {
         context = new DummyContext();
         getCurrentManager().addContext(context);
      }
   }
   

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "b")
   public void testGetWithoutCreationalContextReturnsNull()
   {
      initContext();
      Contextual<MySessionBean> mySessionBean = getCurrentManager().resolveByType(MySessionBean.class).iterator().next();
      assert getCurrentManager().getContext(SessionScoped.class).get(mySessionBean) == null;
   }
   
}
