package org.jboss.jsr299.tck.tests.context;

import javax.context.Context;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.SessionScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson
 * @author Pete Muir
 * @author David Allen
 * 
 *         This class tests a basic context against section 8 of the
 *         specification
 * 
 *         Spec version: PRD2
 */
@Artifact
public class NormalContextTest extends AbstractJSR299Test
{

   Context context;

   public void initContext()
   {
      if (context == null)
      {
         context = new DummyContext();
         getCurrentManager().addContext(context);
      }
   }

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "a")
   public void testGetReturnsExistingInstance()
   {
      initContext();
      Contextual<MySessionBean> mySessionBean = getCurrentManager().resolveByType(MySessionBean.class).iterator().next();
      MyCreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      MySessionBean beanInstance = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, myCreationalContext);
      assert beanInstance != null;
      MySessionBean beanInstanceFromGet = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean);
      assert beanInstanceFromGet == beanInstance;
   }

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "c")
   public void testGetWithCreationalContextReturnsNewInstance()
   {
      initContext();
      MyContextual bean = new MyContextual(getCurrentManager());
      bean.setShouldReturnNullInstances(false);
      getCurrentManager().addBean(bean);

      CreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      assert getCurrentManager().getContext(SessionScoped.class).get(bean, myCreationalContext) != null;
      assert bean.isCreateCalled();
   }

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "d")
   public void testGetMayNotReturnNullUnlessNoCreationalContextOrContextualCreateReturnsNull()
   {
      initContext();
      // The case of no creational context is already tested where a null is
      // returned. Here we just test that the contextual create can return null.
      MyContextual bean = new MyContextual(getCurrentManager());
      bean.setShouldReturnNullInstances(true);
      getCurrentManager().addBean(bean);

      CreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      assert getCurrentManager().getContext(SessionScoped.class).get(bean, myCreationalContext) == null;
      assert bean.isCreateCalled();
   }

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "f")
   public void testContextDestroysBeansWhenDestroyed()
   {
      initContext();
      MyContextual bean = new MyContextual(getCurrentManager());
      bean.setShouldReturnNullInstances(false);
      getCurrentManager().addBean(bean);

      CreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      Context sessionContext = getCurrentManager().getContext(SessionScoped.class);
      assert sessionContext.get(bean, myCreationalContext) != null;
      assert bean.isCreateCalled();
      
      destroyContext(sessionContext);
      assert bean.isDestroyCalled();
   }




   /**
    * There may be no more than one mapped instance per contextual type per
    * thread
    */
   @Test(groups = { "contexts", "stub", "underInvestigation" })
   @SpecAssertion(section = "8.2", id = "a")
   public void testOnlyOneMappedInstancePerContextualTypePerThread()
   {
      assert false;
   }
    
}
