package org.jboss.jsr299.tck.tests.context.conversation;

import java.lang.annotation.Annotation;

import javax.context.Conversation;
import javax.context.RequestScoped;
import javax.inject.Current;
import javax.inject.Standard;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
@Artifact

public class ConversationContextTest extends AbstractJSR299Test
{

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "e")
   public void testDefaultConversationIsTransient()
   {
      assert !getCurrentManager().getInstanceByType(Conversation.class).isLongRunning();
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "ia")
   public void testBeanWithTypeConversation()
   {
      assert getCurrentManager().resolveByType(Conversation.class).size() == 1;
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "ib")
   public void testBeanWithRequestScope()
   {
      assert getCurrentManager().resolveByType(Conversation.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "ic")
   public void testBeanWithDeploymentTypeStandard()
   {
      assert getCurrentManager().resolveByType(Conversation.class).iterator().next().getDeploymentType().equals(Standard.class);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "id")
   public void testBeanWithBindingCurrent()
   {
      boolean found = false;
      for (Annotation binding : getCurrentManager().resolveByType(Conversation.class).iterator().next().getBindings())
      {
         if (binding.annotationType().equals(Current.class))
         {
            found = true;
         }
      }
      assert found;
   }
   
   @Test(groups = { "contexts", "ri-broken" })
   @SpecAssertion(section = "8.5.4", id = "ie")
   public void testBeanWithNameJavaxContextConversation()
   {
      assert getCurrentManager().resolveByType(Conversation.class).iterator().next().getName().equals("javax.context.conversation");
   }

}