package org.jboss.jsr299.tck.tests.context.conversation.client;

import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.jsr299.tck.AbstractJSR299Test;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

public abstract class AbstractConversationTest extends AbstractJSR299Test
{
   
   public static final String CID_HEADER_NAME = "org.jboss.jsr299.tck.cid";
   
   private static final long TIMEOUT = 200;
   
   protected String getCid(HttpClient client) throws Exception
   {
      HttpMethod method = new GetMethod(getConversationStatusPath("cid"));
      ObjectInputStream ois = null;
      try
      {
         client.executeMethod(method);
         ois = new ObjectInputStream(method.getResponseBodyAsStream());
         return (String) ois.readObject();
      }
      finally
      {
         if (ois != null)
         {
            ois.close();
         }
         method.releaseConnection();
      }
   }
   
   
   
   protected boolean isCloudDestroyed(HttpClient client) throws Exception
   {
      HttpMethod method = new GetMethod(getConversationStatusPath("cloudDestroyed"));
      try
      {
         client.executeMethod(method);
         if (method.getStatusCode() == 200)
         {
            return true;
         }
         else
         {
            return false;
         }
      }
      finally
      {
         method.releaseConnection();
      }
   }
   
   protected void resetCloud(HttpClient client) throws Exception
   {
      HttpMethod method = new GetMethod(getConversationStatusPath("resetCloud"));
      try
      {
         client.executeMethod(method);
      }
      finally
      {
         method.releaseConnection();
      }
   }
   
   protected void invalidateSession(HttpClient client) throws Exception
   {
      HttpMethod method = new GetMethod(getConversationStatusPath("invalidateSession"));
      try
      {
         client.executeMethod(method);
      }
      finally
      {
         method.releaseConnection();
      }
   }
   
   protected String getConversationStatusPath(String method)
   {
      return super.getContextPath() + "conversation-status?method=" + method;
   }
   
   protected URL getConversationStatusURL(String method) throws MalformedURLException
   {
      return new URL(getConversationStatusPath(method));
   }
   
   protected String request(HttpClient client, String viewId) throws Exception
   {
      HttpMethod method = new GetMethod(getPath(viewId));
      try
      {
         client.executeMethod(method);
         assert method.getStatusCode() == 200;
         return method.getResponseHeader(CID_HEADER_NAME).getValue();
      }
      finally
      {
         method.releaseConnection();
      }
   }
   
   protected String getBodyAsString(HttpClient client, String viewId) throws Exception
   {
      HttpMethod method = new GetMethod(getPath(viewId));
      try
      {
         client.executeMethod(method);
         assert method.getStatusCode() == 200;
         return method.getResponseBodyAsString();
      }
      finally
      {
         method.releaseConnection();
      }
   }
   
   protected boolean hasRained(HttpClient client, String viewId) throws Exception
   {
      HttpMethod method = new GetMethod(getPath(viewId));
      try
      {
         client.executeMethod(method);
         assert method.getStatusCode() == 200;
         return method.getResponseHeader(Cloud.RAINED_HEADER_NAME).getValue().equals("true") ? true : false;
      }
      finally
      {
         method.releaseConnection();
      }
   }
   
   protected String getPath(String viewId)
   {
      return getContextPath() + viewId;
   }
   
   protected boolean isActiveBeforeApplyRequestValues(HttpClient client, String viewId) throws Exception
   {
      HttpMethod method = new GetMethod(getPath(viewId));
      try
      {
         client.executeMethod(method);
         assert method.getStatusCode() == 200;
         return Boolean.valueOf(method.getResponseHeader(ConversationTestPhaseListener.ACTIVE_BEFORE_APPLY_REQUEST_VALUES_HEADER_NAME).getValue());
      }
      finally
      {
         method.releaseConnection();
      }
   }
   
   protected <T> Set<T> getElements(HtmlElement rootElement, Class<T> elementClass) 
   {
     Set<T> result = new HashSet<T>();
     
     for (HtmlElement element : rootElement.getAllHtmlChildElements()) 
     {
        result.addAll(getElements(element, elementClass));
     }
     
     if (elementClass.isInstance(rootElement)) 
     {
        result.add(elementClass.cast(rootElement));
     }
     return result;
     
   }
 
   protected <T extends HtmlElement> T getFirstMatchingElement(HtmlPage page, Class<T> elementClass, String id) 
   {
     
     Set<T> inputs = getElements(page.getBody(), elementClass);
     for (T input : inputs) 
     {
         if (input.getId().contains(id))
         {
            return input;
         }
     }
     return null;
   }
   
   protected String getCid(HtmlPage page)
   {
      return page.getWebResponse().getResponseHeaderValue(AbstractConversationTest.CID_HEADER_NAME);
   }
   
   
}
