package org.jboss.jsr299.tck.tests.context.dependent;

import javax.context.ApplicationScoped;
import javax.context.Dependent;
import javax.event.Observes;
import javax.inject.Current;
import javax.inject.manager.Manager;

@ApplicationScoped
class ApplicationHorseStable
{
   @Current
   private Manager manager;
   private static boolean dependentContextActive = false;
   
   public void horseEntered(@Observes HorseInStableEvent horseEvent)
   {
      if (manager.getContext(Dependent.class).isActive())
      {
         dependentContextActive = true;
      }
   }

   public static boolean isDependentContextActive()
   {
      return ApplicationHorseStable.dependentContextActive;
   }

   public static void setDependentContextActive(boolean dependentContextActive)
   {
      ApplicationHorseStable.dependentContextActive = dependentContextActive;
   }
}
