package org.jboss.jsr299.tck.tests.context.dependent;

import javax.annotation.Named;
import javax.annotation.PreDestroy;
import javax.inject.Current;

@Named("foxRun")
class FoxRun
{
   
   private static boolean destroyed = false;
   
   @Current
   public Fox fox;
   
   @Current
   public Fox anotherFox;
   
   @PreDestroy
   public void destroy()
   {
      destroyed = true;
   }
   
   public static void setDestroyed(boolean destroyed)
   {
      FoxRun.destroyed = destroyed;
   }
   
   public static boolean isDestroyed()
   {
      return destroyed;
   }
   
}
