package org.jboss.jsr299.tck.tests.context.passivating;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;

import javax.context.Context;
import javax.context.SessionScoped;
import javax.inject.AnnotationLiteral;
import javax.inject.IllegalProductException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson
 * @author David Allen
 * 
 * Spec version: PRD2
 */
@Artifact
@BeansXml("beans.xml")
@Packaging(PackagingType.EAR)
public class PassivatingContextTest extends AbstractJSR299Test
{
   
   private static final Annotation BIG_LITERAL = new AnnotationLiteral<Big>() {};
   
   @Test(groups = { "contexts", "passivation" })
   @SpecAssertion(section = "8.4", id = "b")
   public void testSimpleWebBeanWithSerializableImplementationClassOK()
   {
      Set<Bean<Jyvaskyla>> beans = getCurrentManager().resolveByType(Jyvaskyla.class);
      assert !beans.isEmpty();
   }
   
   @Test @SpecAssertion(section="8.4", id = "ca")
   public void testInjectionOfDependentSerializableProductIntoNormalBean()
   {
      getCurrentManager().getInstanceByType(NumberConsumer.class).ping();
   }
   
   @Test @SpecAssertion(section="8.4", id = "cb")
   public void testInjectionOfDependentPrimitiveProductIntoNormalBean()
   {
      getCurrentManager().getInstanceByType(FooConsumer.class).ping();
   }

   @Test(groups = { "contexts", "passivation" })
   @SpecAssertions({
      @SpecAssertion(section = "8.4", id = "f"),
      @SpecAssertion(section = "8.4", id = "i")
   })
   public void testSimpleWebBeanDeclaringPassivatingScopeIsSerializedWhenContextIsPassivated() throws IOException, ClassNotFoundException
   {
      Kajaani instance = getCurrentManager().getInstanceByType(Kajaani.class);
      instance.setTheNumber(100);
      Context sessionContext = getCurrentManager().getContext(SessionScoped.class);
      setContextInactive(sessionContext);
      setContextActive(sessionContext);
      instance = getCurrentManager().getInstanceByType(Kajaani.class);
      assert instance.getTheNumber() == 100;
   }

   @SuppressWarnings("unchecked")
   private <T> boolean testSerialize(Bean<T> bean) throws IOException, ClassNotFoundException
   {
      getCurrentManager().addBean(bean);
      T instance = getCurrentManager().getInstance(bean);
      byte[] data = serialize(instance);
      T resurrected = (T) deserialize(data);
      return resurrected.toString().equals(instance.toString());
   }

   /**
    * @throws ClassNotFoundException
    * @throws IOException
    */
   @Test(groups = { "contexts", "passivation", "incontainer-ri-broken" })
   @SpecAssertion(section = "8.4", id = "j")
   public void testDependentEJBsAreSerializable() throws IOException, ClassNotFoundException
   {
      Set<Bean<Vaasa>> vaasaBeans = getCurrentManager().resolveByType(Vaasa.class);
      assert vaasaBeans.size() == 1;
      assert testSerialize(vaasaBeans.iterator().next());
   }

   @Test(groups = { "contexts", "passivation" })
   @SpecAssertion(section = "8.4", id = "l")
   public void testSimpleDependentWebBeanWithNonSerializableImplementationInjectedIntoTransientFieldOK()
   {
      Set<Bean<Joensuu>> beans = getCurrentManager().resolveByType(Joensuu.class);
      assert !beans.isEmpty();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "q")
   public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoNonTransientFieldOfWebBeanWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Nokia_Broken.class).ping();
   }

   @Test(groups = { "contexts", "passivation" })
   @SpecAssertion(section = "8.4", id = "q")
   public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoTransientFieldOfWebBeanWithPassivatingScopeOK()
   {
      Set<Bean<Hyvinkaa>> beans = getCurrentManager().resolveByType(Hyvinkaa.class);
      assert !beans.isEmpty();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "r")
   public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoConstructorParameterOfWebBeanWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Loviisa_Broken.class).ping();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "s")
   public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoInitializerParameterOfWebBeanWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Kuopio_Broken.class).ping();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "t")
   public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoProducerMethodParameterWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Violation2.class).ping();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "q")
   public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoNonTransientFieldOfWebBeanWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Uusikaupunki_Broken.class).ping();
   }

   @Test(groups = { "contexts", "passivation" })
   @SpecAssertion(section = "8.4", id = "q")
   public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoTransientFieldOfWebBeanWithPassivatingScopeOK()
   {
      getCurrentManager().getInstanceByType(Salo_Broken.class).ping();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "r")
   public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoConstructorParameterOfWebBeanWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Loviisa_Broken.class).ping();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "s")
   public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoInitializerParameterOfWebBeanWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Mikkeli_Broken.class).ping();
   }

   @Test(groups = { "contexts", "passivation" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "t")
   public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoProducerMethodParameterWithPassivatingScopeFails()
   {
      getCurrentManager().getInstanceByType(Violation2.class, BIG_LITERAL).ping();
   }
   
   @Test(groups = { "contexts", "passivation", "enterpriseBean", "integration" })
   @SpecAssertion(section = "8.4", id = "a")
   public void testEJBWebBeanCanDeclarePassivatingScope()
   {
      assert getCurrentManager().resolveByType(TurkuLocal.class).size() == 1;
   }

}
