package org.jboss.jsr299.tck.tests.definition.binding;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.Production;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.literals.CurrentBinding;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 */
@Artifact
public class BindingDefinitionTest extends AbstractJSR299Test
{

   @Test
   @SpecAssertion(section = "2.3.1", id = "a") 
   public void testDefaultBindingDeclaredInJava()
   {
      Bean<Order> order = getCurrentManager().resolveByType(Order.class).iterator().next();
      assert order.getBindings().size() == 1;
      order.getBindings().iterator().next().annotationType().equals(Production.class);
   }
   
   @Test
   @SpecAssertion(section = "2.3.1", id = "b")
   public void testDefaultBindingForInjectionPoint()
   {
      Bean<Order> order = getCurrentManager().resolveByType(Order.class).iterator().next();     
      InjectionPoint injectionPoint = order.getInjectionPoints().iterator().next();
      assert injectionPoint.getBean().getBindings().iterator().next().annotationType().equals(Current.class);
   }

   @Test(groups = { "annotationDefinition", "stub" })
   @SpecAssertion(section = "2.3.2", id = "aa")
   public void testBindingHasCorrectTarget()
   {
      // TODO This is only a definition without any real assertion about a given
      // binding type
      // If there are many binding types, how do we find them?
      assert false;
   }

   @Test(groups = { "annotationDefinition" })
   @SpecAssertion(section = "2.3.2", id = "b")
   public void testBindingDeclaresBindingAnnotation()
   {
      assert !getCurrentManager().resolveByType(Tarantula.class, new TameBinding()).isEmpty();
   }

   @Test
   @SpecAssertion(section = "2.3.3", id = "a")
   public void testBindingsDeclaredInJava()
   {
      Bean<Cat> cat = getCurrentManager().resolveByType(Cat.class, new SynchronousBinding()).iterator().next();
      assert cat.getBindings().size() == 1;
      assert cat.getBindings().contains(new SynchronousBinding());
   }

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "2.3.3", id = "b"),
      @SpecAssertion(section = "3.2.3", id = "be")
   })
   public void testMultipleBindings()
   {
      Bean<?> model = getCurrentManager().resolveByType(Cod.class, new ChunkyBinding(true), new WhitefishBinding()).iterator().next();
      assert model.getBindings().size() == 2;
   }

   @Test(groups = { "stub", "webbeansxml" })
   @SpecAssertion(section = "2.3.4", id = "a")
   public void testBindingsDeclaredInXml()
   {
      // Map<Class<? extends Annotation>, Annotation> annotations = new
      // HashMap<Class<? extends Annotation>, Annotation>();
      // annotations.put(Asynchronous.class, new
      // AsynchronousAnnotationLiteral());
      // AnnotatedClass annotatedItem = new SimpleAnnotatedClass(Antelope.class,
      // annotations);

      // SimpleBean<Antelope> antelope = createSimpleBean(Antelope.class,
      // annotatedItem, manager);
      // assert Reflections.annotationSetMatches(antelope.getBindingTypes(),
      // Asynchronous.class);
      assert false;
   }

   @Test(groups = { "stub", "webbeansxml" })
   @SpecAssertion(section = "2.3.5", id = "d")
   public void testXmlBindingOverridesAndIgnoresJava()
   {
      // Map<Class<? extends Annotation>, Annotation> annotations = new
      // HashMap<Class<? extends Annotation>, Annotation>();
      // annotations.put(Asynchronous.class, new
      // AsynchronousAnnotationLiteral());
      // AnnotatedClass<Cat> annotatedItem = new
      // SimpleAnnotatedClass<Cat>(Cat.class, annotations);

      // SimpleBean<Cat> cat = createSimpleBean(Cat.class, annotatedItem,
      // manager);
      // assert cat.getBindingTypes().size() == 1;
      // assert cat.getBindingTypes().contains(new
      // AnnotationLiteral<Asynchronous>() {});
      assert false;
   }

   @Test(groups = { "stub", "webbeansxml" })
   @SpecAssertion(section = "2.3.4", id = "a")
   public void testNoBindingsDeclaredInXml()
   {
      // Map<Class<? extends Annotation>, Annotation> annotations = new
      // HashMap<Class<? extends Annotation>, Annotation>();
      // AnnotatedClass<Cat> annotatedItem = new
      // SimpleAnnotatedClass<Cat>(Cat.class, annotations);

      // SimpleBean<Cat> cat = createSimpleBean(Cat.class, annotatedItem,
      // manager);
      // assert cat.getBindingTypes().size() == 1;
      // assert cat.getBindingTypes().contains(new
      // AnnotationLiteral<Synchronous>() {});
      assert false;
   }

   @Test(groups = { "stub", "webbeansxml" })
   @SpecAssertions( { @SpecAssertion(section = "2.3.4", id = "a"), 
      @SpecAssertion(section = "2.3.5", id = "c") })
   public void testDefaultBindingDeclaredInXml()
   {
      Bean<?> model = getCurrentManager().resolveByType(Tuna.class).iterator().next();
      assert model.getBindings().size() == 1;
      assert model.getBindings().contains(new CurrentBinding());
      assert false;
   }

   @Test(groups = { "injection", "producerMethod" })
   @SpecAssertion(section = "2.3.5", id = "a")
   public void testFieldInjectedFromProducerMethod() throws Exception
   {
      Barn barn = getCurrentManager().resolveByType(Barn.class).iterator().next().create(new MockCreationalContext<Barn>());
      assert barn.petSpider != null;
      assert barn.petSpider instanceof DefangedTarantula;
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "2.3.6", id = "b")
   public void testFieldWithBindingInXml()
   {
      assert false;
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "2.3.6", id = "c")
   public void testFieldWithBindingInXmlIgnoresAnnotations()
   {
      assert false;
   }

   @Test(groups = { "injection", "producerMethod" })
   public void testMethodWithBindingAnnotationsOnParametersAreInjected() throws Exception
   {
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            Spider spider = getCurrentManager().getInstanceByType(Spider.class, new AnnotationLiteral<Produced>() {});
            assert spider != null;
            assert spider instanceof DefangedTarantula;
         }
         
      }.run();
         
         
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "2.3.6", id = "e")
   public void testMethodWithBindingAnnotationsOnParametersDeclaredInXml()
   {
      assert false;
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "2.3.6", id = "f")
   public void testMethodWithBindingAnnotationsOnParametersDeclaredInXmlIgnoresAnnotations()
   {
      assert false;
   }

   @Test
   @SpecAssertion(section = "4.1", id = "aa")
   public void testBindingDeclaredInheritedIsInherited() throws Exception
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(BorderCollie.class, new HairyBinding(false)).iterator().next().getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Hairy.class);
   }

   @Test
   @SpecAssertion(section = "4.1", id = "aa")
   public void testBindingNotDeclaredInheritedIsNotInherited()
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(ShetlandPony.class).iterator().next().getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Current.class);
   }

   @Test
   @SpecAssertion(section = "4.1", id = "aa")
   public void testBindingDeclaredInheritedIsBlockedByIntermediateClass()
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(ClippedBorderCollie.class, new HairyBinding(true)).iterator().next().getBindings();
      assert bindings.size() == 1;
      Annotation binding = bindings.iterator().next();
      assert binding.annotationType().equals(Hairy.class);
      Hairy hairy = (Hairy) binding;
      assert hairy.clipped();
   }

}