package org.jboss.jsr299.tck.tests.event.register.observer1;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ConsumerNotifiedForEventTest extends AbstractJSR299Test
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertions( { @SpecAssertion(section = "7.1", id = "h"), @SpecAssertion(section = "7.3", id = "d"), @SpecAssertion(section = "7.4", id = "b") })
   public void testConsumerNotifiedWhenEventTypeAndAllBindingsMatch()
   {
      AnObserver observer1 = new AnObserver();
      AnObserver observer2 = new AnObserver();
      getCurrentManager().addObserver(observer1, AnEventType.class);
      getCurrentManager().addObserver(observer2, AnEventType.class);

      // Fire an event that will be delivered to the two above observers
      AnEventType anEvent = new AnEventType();
      getCurrentManager().fireEvent(anEvent);

      assert observer1.wasNotified;
      assert observer2.wasNotified;
   }


}
