package org.jboss.jsr299.tck.tests.event.resolve.type;

import java.util.ArrayList;
import java.util.Set;

import javax.event.Observer;
import javax.inject.TypeLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ChecksTypeParametersWhenResolvingTest extends AbstractJSR299Test
{
   public static class AListObserver implements Observer<ArrayList<String>>
   {
      public boolean wasNotified = false;

      public void notify(ArrayList<String> event)
      {
         wasNotified = true;
      }
   }

   public static class AnotherListObserver implements Observer<ArrayList<Integer>>
   {
      public boolean wasNotified = false;

      public void notify(ArrayList<Integer> event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "broken", "events" })
   @SpecAssertion(section = "7.7", id = "f")
   public void testResolvingChecksTypeParameters()
   {
      AListObserver observer = new AListObserver();
      AnotherListObserver anotherObserver = new AnotherListObserver();
      getCurrentManager().addObserver(observer, new TypeLiteral<ArrayList<String>>()
      {
      });
      getCurrentManager().addObserver(anotherObserver, new TypeLiteral<ArrayList<Integer>>()
      {
      });
      Set<Observer<ArrayList<String>>> resolvedObservers = getCurrentManager().resolveObservers(new ArrayList<String>());
      //TODO The RI is returning both of the observers above
      assert resolvedObservers.size() == 1;
   }
}
