package org.jboss.jsr299.tck.tests.implementation.enterprise.definition;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
@Artifact
@Packaging(PackagingType.EAR)
public class EnterpriseBeanDefinitionTest extends AbstractJSR299Test
{
   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3", id = "b")
   public void testStatelessWithDependentScopeOK()
   {
      assert getCurrentManager().resolveByType(GiraffeLocal.class).size() == 1;
   }

   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3", id = "c")
   public void testSingletonWithDependentScopeOK()
   {
      assert getCurrentManager().resolveByType(Labrador.class).size() == 1;
   }

   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3", id = "c")
   public void testSingletonWithApplicationScopeOK()
   {
      assert getCurrentManager().resolveByType(Laika.class).size() == 1;
   }

   @Test(groups = { "webbeansxml", "enterpriseBeans", "stub" })
   @SpecAssertion(section = "3.3", id = "e")
   public void testMultipleXMLDefinedEnterpriseBeansWithSameImplementationClassNotOK()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "stub" })
   @SpecAssertion(section = "3.3.2", id = "a")
   public void testAnnotatedEnterpriseBean()
   {
      // TODO: dupe?
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "webbeansxml", "stub" })
   @SpecAssertion(section = "3.3.2", id = "a")
   public void testAnnotatedEnterpriseBeanComplementedWithXML()
   {
      // TODO dupe?
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "ejbjarxml", "stub" })
   @SpecAssertion(section = "3.3.2", id = "b")
   public void testEJBJARDefinedEnterpriseBean()
   {
      // TODO dupe?
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "ejbjarxml", "webbeansxml", "stub" })
   @SpecAssertion(section = "3.3.2", id = "b")
   public void testEJBJARDefinedEnterpriseBeanComplementedWithXML()
   {
      // TODO dupe?
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "stub" })
   @SpecAssertion(section = "3.3.3", id = "a")
   public void testBeanTypesAreLocalInterfacesWithoutWildcardTypesOrTypeVariablesWithSuperInterfaces()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "stub" })
   @SpecAssertion(section = "3.3.3", id = "b")
   public void testEnterpriseBeanWithLocalViewAndParameterizedTypeIncludesBeanClassAndSuperclassesInBeanTypes()
   {
      assert false;
   }

   @Test(groups = "enterpriseBeans")
   @SpecAssertions({
      @SpecAssertion(section = "3.3.3", id = "c"),
      @SpecAssertion(section = "2.2", id = "l")
   })
   public void testObjectIsInAPITypes()
   {
      assert getCurrentManager().resolveByType(GiraffeLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(GiraffeLocal.class).iterator().next().getTypes().contains(Object.class);
   }

   @Test(groups = { "enterpriseBeans", "stub" })
   @SpecAssertion(section = "3.3.3", id = "d")
   public void testRemoteInterfacesAreNotInAPITypes()
   {
      assert false;
   }

   @Test(groups = "enterpriseBeans")
   @SpecAssertion(section = "3.3.8", id = "a")
   public void testDefaultName()
   {
      assert getCurrentManager().resolveByType(PitbullLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(PitbullLocal.class).iterator().next().getName().equals("pitbull");
   }

}
