package org.jboss.jsr299.tck.tests.implementation.enterprise.remove;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
public class EnterpriseBeanRemoveMethodTest extends AbstractJSR299Test
{
   
   @Test(groups = { "enterpriseBeans", "removeMethod", "lifecycle", "stub" })
   @SpecAssertion(section = "3.3.1", id = "da")
   public void applicationMayCallRemoveMethodOnDependentScopedSessionEnterpriseBeansButNoParametersArePassed()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "removeMethod", "lifecycle", "stub" }, expectedExceptions = UnsupportedOperationException.class)
   @SpecAssertion(section = "3.3.1", id = "c")
   public void applicationCannotCallRemoveMethodOnNonDependentScopedSessionEnterpriseBean()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "removeMethod", "lifecycle", "stub" })
   @SpecAssertion(section = "3.3.1", id = "db")
   public void applicationMayCallRemoveMethodOnDependentScopedSessionEnterpriseBeansButInstanceIsNotDestroyed()
   {
      assert false;
   }
   
   @Test(groups = { "enterprisebean", "removemethod", "lifecycle", "stub" })
   @SpecAssertion(section = "3.3.1", id = "b")
   public void testApplicationCalledRemoveMethodOfStatefulSessionBeanWithNonDependentScopeFails()
   {
      assert false;
   }

}
