package org.jboss.jsr299.tck.tests.implementation.producer.field.definition;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.context.RequestScoped;
import javax.inject.AnnotationLiteral;
import javax.inject.Production;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.literals.CurrentBinding;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
@BeansXml("beans.xml")
public class ProducerFieldDefinitionTest extends AbstractJSR299Test
{
   
   private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>() {};
   private static final Annotation FOO_LITERAL = new AnnotationLiteral<Foo>() {};
   private static final Annotation STATIC_LITERAL = new AnnotationLiteral<Static>() {};

   @Test(groups = { "producerField" })
   @SpecAssertion(section = "2.5.3", id = "h")
   public void testProducerFieldInheritsDeploymentTypeOfDeclaringWebBean() throws Exception
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class);
      assert tarantulaBeans.size() == 1;
      assert tarantulaBeans.iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }

   @Test(groups = "producerField")
   @SpecAssertion(section = "3.5", id = "f")
   public void testParameterizedReturnType() throws Exception
   {
      new RunInDependentContext()
      {
         public void execute()
         {
            FunnelWeaverSpiderConsumer spiderConsumer = getCurrentManager().getInstanceByType(FunnelWeaverSpiderConsumer.class);
            assert spiderConsumer != null;
            assert spiderConsumer.getInjectedSpider() != null;
            assert spiderConsumer.getInjectedSpider().equals(FunnelWeaverSpiderProducer.getSpider());
         }
      }.run();
   }

   @Test(groups = { "producerField", "deployment" })
   @SpecAssertions({
      @SpecAssertion(section = "3.5", id = "j"),
      @SpecAssertion(section = "3.5", id = "c"),
      @SpecAssertion(section = "3.5.2", id ="a")
   })
   public void testBeanDeclaresMultipleProducerFields()
   {
      assert getCurrentManager().resolveByType(Tarantula.class, TAME_LITERAL).size() == 1;
      assert getCurrentManager().getInstanceByType(Tarantula.class, TAME_LITERAL).equals(OtherSpiderProducer.TARANTULA) ;
      assert getCurrentManager().resolveByType(BlackWidow.class, TAME_LITERAL).size() == 1;
      assert getCurrentManager().getInstanceByType(BlackWidow.class, TAME_LITERAL).equals(OtherSpiderProducer.BLACK_WIDOW) ;
   }

   @Test(groups = "producerField")
   @SpecAssertions({
     @SpecAssertion(section = "2.3.1", id = "a")
   })
   public void testDefaultBindingType()
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class);
      assert tarantulaBeans.size() == 1;
      assert tarantulaBeans.iterator().next().getBindings().contains(new CurrentBinding());
   }

   @Test(groups = "producerField")
   @SpecAssertion(section = "3.5.1", id = "c")
   public void testApiTypeForClassReturn()
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class);
      assert tarantulaBeans.size() == 1;
      Bean<Tarantula> tarantulaBean = tarantulaBeans.iterator().next();
      assert tarantulaBean.getTypes().size() == 6;
      assert tarantulaBean.getTypes().contains(Tarantula.class);
      assert tarantulaBean.getTypes().contains(DeadlySpider.class);
      assert tarantulaBean.getTypes().contains(Spider.class);
      assert tarantulaBean.getTypes().contains(Animal.class);
      assert tarantulaBean.getTypes().contains(DeadlyAnimal.class);
      assert tarantulaBean.getTypes().contains(Object.class);
   }

   @Test(groups = { "producerField" })
   @SpecAssertion(section = "3.5.1", id = "a")
   public void testApiTypeForInterfaceReturn()
   {
      Set<Bean<Animal>> animalBeans = getCurrentManager().resolveByType(Animal.class, new AnnotationLiteral<AsAnimal>() {});
      assert animalBeans.size() == 1;
      Bean<Animal> animalModel = animalBeans.iterator().next();
      assert animalModel.getTypes().size() == 2;
      assert animalModel.getTypes().contains(Animal.class);
      assert animalModel.getTypes().contains(Object.class);
   }

   @Test(groups = { "producerField" })
   @SpecAssertion(section = "3.5.1", id = "b")
   public void testApiTypeForPrimitiveReturn()
   {
      Set<Bean<?>> beans = getCurrentManager().resolveByName("SpiderSize");
      assert beans.size() == 1;
      Bean<?> intModel = beans.iterator().next();
      assert intModel.getTypes().size() == 2;
      assert intModel.getTypes().contains(int.class);
      assert intModel.getTypes().contains(Object.class);
   }

   @Test(groups = { "producerField" })
   @SpecAssertions({
     @SpecAssertion(section = "3.5.1", id = "b"),
     @SpecAssertion(section = "2.2", id = "j")
   })
   public void testApiTypeForArrayTypeReturn()
   {
      Set<Bean<Spider[]>> spidersBeans = getCurrentManager().resolveByType(Spider[].class);
      assert spidersBeans.size() == 1;
      Bean<Spider[]> spidersModel = spidersBeans.iterator().next();
      assert spidersModel.getTypes().size() == 2;
      assert spidersModel.getTypes().contains(Spider[].class);
      assert spidersModel.getTypes().contains(Object.class);
   }

   @Test(groups = "producerField")
   @SpecAssertions({
      @SpecAssertion(section = "3.5.2", id = "f"),
      @SpecAssertion(section="2.3.3", id="c")
   })
   public void testBindingType()
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class, new TameAnnotationLiteral());
      assert tarantulaBeans.size() == 1;
      Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
      assert tarantulaModel.getBindings().size() == 1;
      assert tarantulaModel.getBindings().iterator().next().annotationType().equals(Tame.class);
   }

   @Test(groups = "producerField")
   @SpecAssertion(section = "3.5.2", id = "b")
   public void testScopeType()
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class, TAME_LITERAL, FOO_LITERAL);
      assert !tarantulaBeans.isEmpty();
      Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
      assert tarantulaModel.getScopeType().equals(RequestScoped.class);
   }

   @Test(groups = "producerField")
   @SpecAssertion(section = "3.5.2", id = "d")
   public void testDeploymentType()
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class, TAME_LITERAL, FOO_LITERAL);
      assert !tarantulaBeans.isEmpty();
      Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
      assert tarantulaModel.getDeploymentType().equals(Production.class);
   }

   @Test(groups = "producerField")
   @SpecAssertions({
      @SpecAssertion(section = "3.5.2", id = "c"),
      @SpecAssertion(section="2.6.1", id = "c")
   })
   public void testNamedField()
   {
      Set<Bean<?>> beans = getCurrentManager().resolveByName("blackWidow");
      assert beans.size() == 1;

      @SuppressWarnings("unchecked")
      Bean<BlackWidow> blackWidowModel = (Bean<BlackWidow>) beans.iterator().next();
      assert blackWidowModel.getName().equals("blackWidow");
   }
   
   @Test(groups = { "producerField" })
   @SpecAssertions({
     @SpecAssertion(section = "2.6.3", id = "b"),
     @SpecAssertion(section = "3.5.4", id = "a"),
     @SpecAssertion(section = "2.6.1", id = "d")
   })
   public void testDefaultNamedField()
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class, STATIC_LITERAL);
      assert tarantulaBeans.size() == 1;
      Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
      assert tarantulaModel.getName().equals("produceTarantula");
   }

   // review 2.2
   @Test(groups = "producerField")
   @SpecAssertions({
     @SpecAssertion(section = "2.7.2", id = "c"),
     @SpecAssertion(section = "3.5.2", id = "e")
   })
   public void testStereotype()
   {
      Set<Bean<Tarantula>> tarantulaBeans = getCurrentManager().resolveByType(Tarantula.class, STATIC_LITERAL);
      assert !tarantulaBeans.isEmpty();
      Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
      assert tarantulaModel.getScopeType().equals(RequestScoped.class);
      assert tarantulaModel.getDeploymentType().equals(Production.class);
   }

   @Test(groups = "producerField")
   @SpecAssertion(section = "4.2", id = "ea")
   public void testNonStaticProducerFieldNotInherited()
   {
      assert !(getCurrentManager().getInstanceByType(Egg.class, FOO_LITERAL).getMother() instanceof InfertileChicken);
   }
}