package org.jboss.jsr299.tck.tests.implementation.producer.method.definition;

import java.lang.annotation.Annotation;

import javax.context.RequestScoped;
import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.TypeLiteral;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class ProducerMethodDefinitionTest extends AbstractJSR299Test
{
   
   private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>() {}; 

   @Test(groups = "producerMethod")
   @SpecAssertion(section = "2.5.3", id = "g")
   public void testProducerMethodInheritsDeploymentTypeOfDeclaringWebBean() throws Exception
   {
      assert getCurrentManager().resolveByType(Tarantula.class, TAME_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(Tarantula.class, TAME_LITERAL).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertions( { 
      @SpecAssertion(section = "3.4", id = "b"), 
      @SpecAssertion(section = "6.7", id = "a"),
      @SpecAssertion(section = "6.7", id = "f")
   } )
   public void testStaticMethod() throws Exception
   {
      assert getCurrentManager().resolveByType(String.class).size() == 1;
      assert getCurrentManager().getInstanceByType(String.class).equals(BeanWithStaticProducerMethod.getString());
   }

   @Test(groups = "producerMethod")
   @SpecAssertion(section = "3.4", id = "g")
   public void testParameterizedReturnType() throws Exception
   {
      assert getCurrentManager().resolveByType(new TypeLiteral<FunnelWeaver<Spider>>() {}).size() == 1;
   }

   @Test(groups = "producerMethod")
   @SpecAssertions({
      @SpecAssertion(section = "3.4", id = "b"), 
      @SpecAssertion(section = "2.3.1", id = "a") 
   })
   public void testDefaultBindingType() throws Exception
   {
      assert getCurrentManager().resolveByType(Tarantula.class).size() == 1;
      assert getCurrentManager().resolveByType(Tarantula.class).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(Tarantula.class).iterator().next().getBindings().iterator().next().annotationType().equals(Current.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertions({
      @SpecAssertion(section = "3.4.1", id = "c"),
      @SpecAssertion(section="2.2", id = "l")
   })
   public void testApiTypeForClassReturn() throws Exception
   {
      assert getCurrentManager().resolveByType(Tarantula.class).size() == 1;
      Bean<Tarantula> tarantula = getCurrentManager().resolveByType(Tarantula.class).iterator().next();
      
      assert tarantula.getTypes().size() == 6;
      assert tarantula.getTypes().contains(Tarantula.class);
      assert tarantula.getTypes().contains(DeadlySpider.class);
      assert tarantula.getTypes().contains(Spider.class);
      assert tarantula.getTypes().contains(Animal.class);
      assert tarantula.getTypes().contains(DeadlyAnimal.class);
      assert tarantula.getTypes().contains(Object.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertion(section = "3.4.1", id = "a")
   public void testApiTypeForInterfaceReturn() throws Exception
   {
      assert getCurrentManager().resolveByType(Bite.class).size() == 1;
      Bean<Bite> animal = getCurrentManager().resolveByType(Bite.class).iterator().next();
      assert animal.getTypes().size() == 2;
      assert animal.getTypes().contains(Bite.class);
      assert animal.getTypes().contains(Object.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertion(section = "3.4.1", id = "b")
   public void testApiTypeForPrimitiveReturn() throws Exception
   {
      assert getCurrentManager().resolveByType(Integer.class).size() == 1;
      Bean<Integer> integer = getCurrentManager().resolveByType(Integer.class).iterator().next();
      assert integer.getTypes().size() == 2;
      assert integer.getTypes().contains(int.class);
      assert integer.getTypes().contains(Object.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertions({
      @SpecAssertion(section = "3.4.1", id = "b"), 
      @SpecAssertion(section = "2.2", id = "j") 
   })
   public void testApiTypeForArrayTypeReturn() throws Exception
   {
      assert getCurrentManager().resolveByType(Spider[].class).size() == 1;
      Bean<Spider[]> spiders = getCurrentManager().resolveByType(Spider[].class).iterator().next();
      assert spiders.getTypes().size() == 2;
      assert spiders.getTypes().contains(Spider[].class);
      assert spiders.getTypes().contains(Object.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertion(section = "3.4.2", id = "be")
   public void testBindingType() throws Exception
   {
      assert getCurrentManager().resolveByType(Tarantula.class, TAME_LITERAL).size() == 1;
      Bean<Tarantula> tarantula = getCurrentManager().resolveByType(Tarantula.class, TAME_LITERAL).iterator().next();
      assert tarantula.getBindings().size() == 1;
      assert tarantula.getBindings().iterator().next().annotationType().equals(Tame.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertion(section = "3.4.2", id = "ba")
   public void testScopeType() throws Exception
   {
      assert getCurrentManager().resolveByType(DaddyLongLegs.class).size() == 1;
      Bean<DaddyLongLegs> daddyLongLegs = getCurrentManager().resolveByType(DaddyLongLegs.class).iterator().next();
      assert daddyLongLegs.getScopeType().equals(RequestScoped.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertions({
      @SpecAssertion(section = "3.4.2", id = "bc"),
      @SpecAssertion(section = "2.5.3", id = "b")
   })
   public void testDeploymentType() throws Exception
   {
      assert getCurrentManager().resolveByType(LadybirdSpider.class).size() == 1;
      Bean<LadybirdSpider> ladybirdSpider = getCurrentManager().resolveByType(LadybirdSpider.class).iterator().next();
      assert ladybirdSpider.getDeploymentType().equals(SpiderDeploymentType.class);
   }

   @Test(groups = "producerMethod")
   @SpecAssertions({
      @SpecAssertion(section = "3.4.2", id = "bb"),
      @SpecAssertion(section = "2.6.1", id = "b")
   })
   public void testNamedMethod() throws Exception
   {
      assert getCurrentManager().resolveByType(BlackWidow.class).size() == 1;
      Bean<BlackWidow> blackWidowSpider = getCurrentManager().resolveByType(BlackWidow.class).iterator().next();
      assert blackWidowSpider.getName().equals("blackWidow");
   }

   @Test(groups = "producerMethod")
   @SpecAssertions({
      @SpecAssertion(section = "3.4.2", id = "bb"),
      @SpecAssertion(section = "2.6.1", id = "d"),
      @SpecAssertion(section = "3.4.12", id = "a")
   })
   public void testDefaultNamedMethod() throws Exception
   {
      assert getCurrentManager().resolveByType(DaddyLongLegs.class).size() == 1;
      Bean<DaddyLongLegs> daddyLongLegsSpider = getCurrentManager().resolveByType(DaddyLongLegs.class).iterator().next();
      assert daddyLongLegsSpider.getName().equals("produceDaddyLongLegs");
   }




   // Review 2.2
   @Test(groups = "producerMethod")
   @SpecAssertions({ 
      @SpecAssertion(section = "2.7.2", id = "b"), 
      @SpecAssertion(section = "3.4.2", id = "ba"), 
      @SpecAssertion(section = "2.4.5", id = "c"),
      @SpecAssertion(section = "3.4.2", id = "bd")
   })
   public void testStereotypeSpecifiesScope() throws Exception
   {
      assert getCurrentManager().resolveByType(WolfSpider.class).size() == 1;
      Bean<WolfSpider> wolfSpider = getCurrentManager().resolveByType(WolfSpider.class).iterator().next();
      assert wolfSpider.getScopeType().equals(RequestScoped.class);
   }

   @Test(groups="ri-broken")
   @SpecAssertion(section = "4.2", id = "da")
   public void testNonStaticProducerMethodNotInherited()
   {
      assert getCurrentManager().resolveByType(Egg.class, new AnnotationLiteral<Yummy>() {}).size() == 1;
      System.out.println(getCurrentManager().getInstanceByType(Egg.class, new AnnotationLiteral<Yummy>() {}).getMother().getClass());
      assert getCurrentManager().getInstanceByType(Egg.class, new AnnotationLiteral<Yummy>() {}).getMother().getClass().equals(Chicken.class);
   }
}
