package org.jboss.jsr299.tck.tests.implementation.simple.newSimpleBean;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Set;

import javax.context.Dependent;
import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.New;
import javax.inject.Standard;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.literals.NewLiteral;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
public class NewSimpleBeanTest extends AbstractJSR299Test
{

   private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>()
   {
   };

   @Test(groups = { "new" })
   @SpecAssertion(section = "3.2.5", id = "d")
   public void testNewBeanIsDependentScoped()
   {
      Set<Bean<WrappedSimpleBean>> beans = getCurrentManager().resolveByType(WrappedSimpleBean.class, new NewLiteral());
      assert beans.size() == 1;
      Bean<WrappedSimpleBean> newSimpleBean = beans.iterator().next();
      assert Dependent.class.equals(newSimpleBean.getScopeType());
   }

   @Test(groups = { "new" })
   @SpecAssertion(section = "3.2.5", id = "e")
   public void testNewBeanIsOfStandardDeploymentType()
   {
      Set<Bean<WrappedSimpleBean>> beans = getCurrentManager().resolveByType(WrappedSimpleBean.class, new NewLiteral());
      assert beans.size() == 1;
      Bean<WrappedSimpleBean> newSimpleBean = beans.iterator().next();
      assert Standard.class.equals(newSimpleBean.getDeploymentType());
   }

   @Test(groups = { "new" })
   @SpecAssertion(section = "3.2.5", id = "f")
   public void testNewBeanHasOnlyNewBinding()
   {
      Set<Bean<WrappedSimpleBean>> beans = getCurrentManager().resolveByType(WrappedSimpleBean.class, new NewLiteral());
      assert beans.size() == 1;
      Bean<WrappedSimpleBean> newSimpleBean = beans.iterator().next();
      assert newSimpleBean.getBindings().size() == 1;
      assert newSimpleBean.getBindings().iterator().next().annotationType().equals(new NewLiteral().annotationType());
   }

   @Test(groups = { "new" })
   @SpecAssertion(section = "3.2.5", id = "g")
   public void testNewBeanHasNoWebBeanName()
   {
      Set<Bean<WrappedSimpleBean>> beans = getCurrentManager().resolveByType(WrappedSimpleBean.class, new NewLiteral());
      assert beans.size() == 1;
      Bean<WrappedSimpleBean> newSimpleBean = beans.iterator().next();
      assert newSimpleBean.getName() == null;
   }

   @Test(groups = { "stub", "new" })
   @SpecAssertion(section = "3.2.5", id = "h")
   public void testNewBeanHasNoStereotypes()
   {
      assert false;
   }

   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.2.5", id = "i")
   public void testNewBeanHasNoObservers()
   {
      assert false;
   }

   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.2.5", id = "k")
   public void testNewBeanHasNoProducerFields()
   {
      assert false;
   }

   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.2.5", id = "j")
   public void testNewBeanHasNoProducerMethods()
   {
      assert false;
   }

   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.2.5", id = "l")
   public void testNewBeanHasNoDisposalMethods()
   {
      assert false;
   }

   @Test(groups = { "stub", "new" })
   @SpecAssertion(section = "3.2.5", id = "c")
   public void testNewBeanHasSameInterceptorMethodsAsWrappedBean()
   {
      assert false;
   }

   @Test(groups = { "new" })
   @SpecAssertion(section = "review", id = "review")
   public void testNewAnnotationCannotBeExplicitlyDeclared()
   {
      // All we can really do is make sure the annotation itself
      // prevents the compiler from violating the assertion
      Target target = New.class.getAnnotation(Target.class);
      for (ElementType elementType : target.value())
      {
         assert !elementType.equals(ElementType.TYPE);
      }
   }

   @Test
   @SpecAssertion(section = "3.2.5", id = "a")
   public void testForEachSimpleBeanANewBeanExists()
   {
      assert getCurrentManager().resolveByType(Order.class).size() == 1;
      assert getCurrentManager().resolveByType(Order.class).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(Order.class).iterator().next().getBindings().iterator().next().annotationType().equals(Current.class);

      assert getCurrentManager().resolveByType(Order.class, new NewLiteral()).size() == 1;
      assert getCurrentManager().resolveByType(Order.class, new NewLiteral()).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(Order.class, new NewLiteral()).iterator().next().getBindings().iterator().next().annotationType().equals(New.class);

      assert getCurrentManager().resolveByType(Lion.class, TAME_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(Lion.class, TAME_LITERAL).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(Lion.class, TAME_LITERAL).iterator().next().getBindings().iterator().next().annotationType().equals(Tame.class);

      assert getCurrentManager().resolveByType(Lion.class, new NewLiteral()).size() == 1;
      assert getCurrentManager().resolveByType(Lion.class, new NewLiteral()).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(Lion.class, new NewLiteral()).iterator().next().getBindings().iterator().next().annotationType().equals(New.class);
   }

}
