package org.jboss.jsr299.tck.tests.lookup.typesafe.instantiation;

import javax.inject.AmbiguousDependencyException;
import javax.inject.AnnotationLiteral;
import javax.inject.DuplicateBindingTypeException;
import javax.inject.TypeLiteral;
import javax.inject.UnsatisfiedDependencyException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.literals.CurrentBinding;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
@BeansXml("beans.xml")
public class InstantiationByTypeTest extends AbstractJSR299Test
{
   
   @Test(groups={"resolution", "beanLifecycle"}) 
   @SpecAssertion(section="5.7.2", id = "h")
   public void testCurrentBindingTypeAssumed()
   {
      assert getCurrentManager().getInstanceByType(Tuna.class) != null;
   }
   
   @Test(groups="resolution", expectedExceptions=IllegalArgumentException.class) 
   @SpecAssertion(section="5.7.2", id = "ib")
   public void testParameterizedTypeWithWildcardParameter()
   {
      getCurrentManager().getInstanceByType(new TypeLiteral<ParameterizedBean_Broken<?>>(){});
   }
   
   @Test(groups="resolution", expectedExceptions=IllegalArgumentException.class) 
   @SpecAssertion(section="5.7.2", id = "ia")
   public  <T> void testParameterizedTypeWithTypeParameter()
   {
      getCurrentManager().getInstanceByType(new TypeLiteral<ParameterizedBean_Broken<T>>(){});
   }
   
   
   @Test(groups="resolution", expectedExceptions=DuplicateBindingTypeException.class) 
   @SpecAssertion(section="5.7.2", id = "j")
   public void testDuplicateBindingTypesUsed()
   {
      getCurrentManager().getInstanceByType(Tuna.class, new CurrentBinding(), new CurrentBinding());
   }
   
   @Test(groups="resolution", expectedExceptions=IllegalArgumentException.class) 
   @SpecAssertion(section="5.7.2", id = "k")
   public void testNonBindingTypeUsed()
   {
      getCurrentManager().getInstanceByType(Tuna.class, new AnotherDeploymentTypeLiteral());
   }
   
   @Test(expectedExceptions=AmbiguousDependencyException.class) 
   @SpecAssertion(section="5.7.2", id = "n")
   public void testAmbiguousDependencies() throws Exception
   {
      getCurrentManager().getInstanceByType(ScottishFish.class, new AnnotationLiteral<Whitefish>(){});
   }
   
   @Test(expectedExceptions=UnsatisfiedDependencyException.class) 
   @SpecAssertion(section="5.7.2", id = "m")
   public void testUnsatisfiedDependencies() throws Exception
   {
      getCurrentManager().getInstanceByType(Tuna.class, new AnnotationLiteral<FakeFish>() {});
   }  
}
