package org.jboss.jsr299.tck.tests.activities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

import javax.context.Context;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.event.Observer;
import javax.inject.AnnotationLiteral;
import javax.inject.Production;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;
import javax.inject.manager.Manager;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.ForwardingBean;
import org.jboss.jsr299.tck.literals.CurrentLiteral;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ActivitiesTest extends AbstractJSR299Test
{
   
   private static final Set<Annotation> DEFAULT_BINDINGS = new HashSet<Annotation>();
   
   static
   {
      DEFAULT_BINDINGS.add(new CurrentLiteral());
   }
   
   private Bean<?> createDummyBean(Manager manager, final Type injectionPointType)
   {
      final Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
      final Set<Type> types = new HashSet<Type>();
      final Set<Annotation> bindings = new HashSet<Annotation>();
      bindings.add(new AnnotationLiteral<Tame>() {});
      types.add(Object.class);
      final Bean<?> bean = new Bean<Object>(manager)
      {

         @Override
         public Set<Annotation> getBindings()
         {
            return bindings;
         }

         @Override
         public Class<? extends Annotation> getDeploymentType()
         {
            return Production.class;
         }

         @Override
         public Set<? extends InjectionPoint> getInjectionPoints()
         {
            return injectionPoints;
         }

         @Override
         public String getName()
         {
            return null;
         }

         @Override
         public Class<? extends Annotation> getScopeType()
         {
            return Dependent.class;
         }

         @Override
         public Set<Type> getTypes()
         {
            return types;
         }

         @Override
         public boolean isNullable()
         {
            return false;
         }

         @Override
         public boolean isSerializable()
         {
            return false;
         }

         public Object create(CreationalContext<Object> creationalContext)
         {
            return null;
         }

         public void destroy(Object instance)
         {
            
         }
         
      };
      InjectionPoint injectionPoint = new InjectionPoint()
      {

         public <T extends Annotation> T getAnnotation(Class<T> annotationType)
         {
            return null;
         }

         public Annotation[] getAnnotations()
         {
            return new Annotation[0];
         }

         public Bean<?> getBean()
         {
            return bean;
         }

         public Set<Annotation> getBindings()
         {
            return DEFAULT_BINDINGS;
         }

         public Member getMember()
         {
            return null;
         }

         public Type getType()
         {
            return injectionPointType;
         }

         public boolean isAnnotationPresent(Class<? extends Annotation> annotationType)
         {
            return false;
         }
         
      };
      injectionPoints.add(injectionPoint);
      return bean;
   }
   
   private static class DummyContext implements Context
   {

      public <T> T get(Contextual<T> contextual)
      {
         return null;
      }

      public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext)
      {
         return null;
      }

      public Class<? extends Annotation> getScopeType()
      {
         return Dummy.class;
      }

      public boolean isActive()
      {
         return false;
      }
      
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section="11.6", id="b"),
      @SpecAssertion(section="11.6", id="m")
   })
   public void testBeanBelongingToParentActivityBelongsToChildActivity()
   {
      assert getCurrentManager().resolveByType(Cow.class).size() == 1;
      Bean<?> bean = getCurrentManager().resolveByType(Cow.class).iterator().next();
      Manager childActivity = getCurrentManager().createActivity();
      assert childActivity.resolveByType(Cow.class).size() == 1;
      assert childActivity.resolveByType(Cow.class).iterator().next().equals(bean);
   }
   
   @Test
   @SpecAssertion(section="11.6", id="c")
   public void testBeanBelongingToParentActivityCanBeInjectedIntoChildActivityBean()
   {
      assert getCurrentManager().resolveByType(Cow.class).size() == 1;
      Bean<?> bean = getCurrentManager().resolveByType(Cow.class).iterator().next();
      Manager childActivity = getCurrentManager().createActivity();
      Bean<?> dummyBean = createDummyBean(childActivity, Cow.class);
      childActivity.addBean(dummyBean);
      assert childActivity.getInstanceToInject(dummyBean.getInjectionPoints().iterator().next()) != null;
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section="11.6", id="j"),
      @SpecAssertion(section="11.6", id="n")
   })
   public void testObserverBelongingToParentActivityBelongsToChildActivity()
   {
      assert getCurrentManager().resolveObservers(new NightTime()).size() == 1;
      Observer<?> observer = getCurrentManager().resolveObservers(new NightTime()).iterator().next();
      Manager childActivity = getCurrentManager().createActivity();
      assert childActivity.resolveObservers(new NightTime()).size() == 1;
      assert childActivity.resolveObservers(new NightTime()).iterator().next().equals(observer);
   }
   
   @Test
   @SpecAssertion(section="11.6", id="k")
   public void testObserverBelongingToParentFiresForChildActivity()
   {
      Fox.setObserved(false);
      Manager childActivity = getCurrentManager().createActivity();
      childActivity.fireEvent(new NightTime());
      assert Fox.isObserved();
   }
   
   @Test
   @SpecAssertion(section="11.6", id="l")
   public void testContextObjectBelongingToParentBelongsToChild()
   {
      Context context = new DummyContext()
      {
         
         @Override
         public boolean isActive()
         {
            return true;
         }
         
      };
      getCurrentManager().addContext(context);
      Manager childActivity = getCurrentManager().createActivity();
      assert childActivity.getContext(Dummy.class) != null;
   }
   
   @Test
   @SpecAssertion(section="11.6", id="o")
   public void testBeanBelongingToChildActivityCannotBeInjectedIntoParentActivityBean()
   {
      assert getCurrentManager().resolveByType(Cow.class).size() == 1;
      Manager childActivity = getCurrentManager().createActivity();
      Bean<?> dummyBean = createDummyBean(childActivity, Cow.class);
      childActivity.addBean(dummyBean);
      assert getCurrentManager().resolveByType(Object.class, new AnnotationLiteral<Tame>() {}).size() == 0;
   }
   
   @Test(expectedExceptions=UnsatisfiedDependencyException.class)
   @SpecAssertion(section="11.6", id="r")
   public void testInstanceProcessedByParentActivity()
   {
      Context dummyContext = new DummyContext();
      getCurrentManager().addContext(dummyContext);
      assert getCurrentManager().resolveByType(Cow.class).size() == 1;
      final Bean<Cow> bean = getCurrentManager().resolveByType(Cow.class).iterator().next();
      Manager childActivity = getCurrentManager().createActivity();
      final Set<Annotation> bindingTypes = new HashSet<Annotation>();
      bindingTypes.add(new AnnotationLiteral<Tame>() {});
      childActivity.addBean(new ForwardingBean<Cow>(childActivity)
      {

         @Override
         protected Bean<Cow> delegate()
         {
            return bean;
         }
         
         @Override
         public Set<Annotation> getBindings()
         {
            return bindingTypes;
         }
         
      });
      getCurrentManager().getInstanceByType(Field.class).get();
   }
   
   @Test
   @SpecAssertion(section="11.6", id="s")
   public void testObserverBelongingToChildDoesNotFireForParentActivity()
   {
      Manager childActivity = getCurrentManager().createActivity();
      Observer<NightTime> observer = new Observer<NightTime>()
      {

         public void notify(NightTime event)
         {
            assert false;
         }
         
      };
      childActivity.addObserver(observer, NightTime.class);
      getCurrentManager().fireEvent(new NightTime());
   }
   
}
