package org.jboss.jsr299.tck.tests.activities.current;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.context.Context;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.event.Observer;
import javax.inject.AnnotationLiteral;
import javax.inject.Production;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;
import javax.inject.manager.Manager;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ELCurrentActivityTest extends AbstractJSR299Test
{
   
   static interface TestableObserver<T> extends Observer<T>
   {
      
      boolean isObserved();
      
   }
   
   
   private static class DummyContext implements Context
   {
      
      private boolean active = true;

      public <T> T get(Contextual<T> contextual)
      {
         return null;
      }

      public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext)
      {
         return null;
      }

      public Class<? extends Annotation> getScopeType()
      {
         return Dummy.class;
      }

      public boolean isActive()
      {
         return active;
      }
      
      public void setActive(boolean active)
      {
         this.active = active;
      }
      
   }
   
   private static class Daisy extends Bean<Cow>
   {
      
      private static final Set<Type> TYPES = new HashSet<Type>();
      
      private final static Set<Annotation> BINDING_TYPES = new HashSet<Annotation>();
      
      
      static
      {
         TYPES.add(Cow.class);
         TYPES.add(Object.class);
         BINDING_TYPES.add(new AnnotationLiteral<Tame>() {});
      }
      
      public Daisy(Manager manager)
      {
         super(manager);
      }

      @Override
      public Set<Annotation> getBindings()
      {
         return BINDING_TYPES;
      }

      @Override
      public Class<? extends Annotation> getDeploymentType()
      {
         return Production.class;
      }

      @Override
      public Set<? extends InjectionPoint> getInjectionPoints()
      {
         return Collections.emptySet();
      }

      @Override
      public String getName()
      {
         return "daisy";
      }

      @Override
      public Class<? extends Annotation> getScopeType()
      {
         return Dependent.class;
      }

      @Override
      public Set<Type> getTypes()
      {
         return TYPES;
      }

      @Override
      public boolean isNullable()
      {
         return true;
      }

      @Override
      public boolean isSerializable()
      {
         return false;
      }

      public Dummy create(CreationalContext<Dummy> creationalContext)
      {
         return null;
      }

      public void destroy(Dummy instance)
      {
         
      }

      public Cow create(CreationalContext<Cow> creationalContext)
      {
         return new Cow();
      }

      public void destroy(Cow instance)
      {
         // TODO Auto-generated method stub
         
      }
      
   }
   
   @Test
   @SpecAssertion(section="11.6.1", id="d")
   public void testELEvaluationProcessedByCurrentActivty()
   {
      Context dummyContext = new DummyContext();
      getCurrentManager().addContext(dummyContext);
      assert getCurrentManager().resolveByType(Cow.class).size() == 1;
      Manager childActivity = getCurrentManager().createActivity();
      childActivity.addBean(new Daisy(childActivity));
      childActivity.setCurrent(dummyContext.getScopeType());
      assert getCurrentConfiguration().getEl().evaluateValueExpression("#{daisy}", Cow.class) != null;
   }
   
}
