package org.jboss.jsr299.tck.tests.activities.current;

import java.lang.annotation.Annotation;

import javax.context.Context;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.event.Observer;
import javax.inject.manager.Manager;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.testng.annotations.Test;

@Artifact
@IntegrationTest
public class JndiManagerCurrentActivityTest extends AbstractJSR299Test
{
   
   static interface TestableObserver<T> extends Observer<T>
   {
      
      boolean isObserved();
      
   }
   
   
   private static class DummyContext implements Context
   {
      
      private boolean active = true;

      public <T> T get(Contextual<T> contextual)
      {
         return null;
      }

      public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext)
      {
         return null;
      }

      public Class<? extends Annotation> getScopeType()
      {
         return Dummy.class;
      }

      public boolean isActive()
      {
         return active;
      }
      
      public void setActive(boolean active)
      {
         this.active = active;
      }
      
   }
   
   @Test
   @SpecAssertion(section="11.6.1", id="f")
   public void testJndiManagerIsCurrentActivity()
   {
      Context dummyContext = new DummyContext();
      getCurrentManager().addContext(dummyContext);
      assert getCurrentManager().resolveByType(Cow.class).size() == 1;
      Manager childActivity = getCurrentManager().createActivity();
      childActivity.setCurrent(dummyContext.getScopeType());
      assert getCurrentManager().getInstanceByType(Donkey.class).getManager().equals(childActivity);
   }
   
}
