package org.jboss.jsr299.tck.tests.context;

import javax.context.Context;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.SessionScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class GetOnInactiveContextTest extends AbstractJSR299Test
{
   @Test(groups = { "contexts" }, expectedExceptions = { ContextNotActiveException.class })
   @SpecAssertion(section = "8.1", id = "h")
   public void testInvokingGetOnInactiveContextFails()
   {
      Context sessionContext = getCurrentManager().getContext(SessionScoped.class);
      assert sessionContext.isActive();
      setContextInactive(sessionContext);

      Contextual<MySessionBean> mySessionBean = getCurrentManager().resolveByType(MySessionBean.class).iterator().next();
      sessionContext.get(mySessionBean);
   }
   
}
