package org.jboss.jsr299.tck.tests.context;

import javax.context.ContextNotActiveException;
import javax.context.RequestScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class InactiveContextTest extends AbstractJSR299Test
{
   

   @Test(expectedExceptions = { ContextNotActiveException.class }, groups = { "manager" })
   @SpecAssertion(section = "8.6", id = "c")
   public void testGetContextWithNoActiveContextsFails()
   {
      getCurrentConfiguration().getContexts().setInactive(getCurrentConfiguration().getContexts().getRequestContext());
      getCurrentManager().getContext(RequestScoped.class);
   }
   
}
