package org.jboss.jsr299.tck.tests.context;

import javax.context.Context;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.SessionScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * This class tests a basic context against section 8 of the specification 
 * 
 * Spec version: PRD2
 * 
 * @author Nicklas Karlsson
 * @author Pete Muir
 * @author David Allen
 */
@Artifact
public class NormalContextTest extends AbstractJSR299Test
{

   @Test(groups = { "contexts" })
   @SpecAssertions( { 
      @SpecAssertion(section = "8.1", id = "a"), 
      @SpecAssertion(section = "8.2", id = "c") 
   } )
   public void testGetReturnsExistingInstance()
   {
      Contextual<MySessionBean> mySessionBean = getCurrentManager().resolveByType(MySessionBean.class).iterator().next();
      MyCreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      MySessionBean beanInstance = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, myCreationalContext);
      assert beanInstance != null;
      MySessionBean beanInstanceFromGet = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean);
      assert beanInstanceFromGet == beanInstance;
   }

   @Test(groups = { "contexts" })
   @SpecAssertions( { 
      @SpecAssertion(section = "8.1", id = "c")
   } )
   public void testGetWithCreationalContextReturnsNewInstance()
   {
      MyContextual bean = new MyContextual(getCurrentManager());
      bean.setShouldReturnNullInstances(false);
      getCurrentManager().addBean(bean);

      MyCreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      MySessionBean newBean = getCurrentManager().getContext(SessionScoped.class).get(bean, myCreationalContext);
      assert newBean != null;
      assert bean.isCreateCalled();
   }

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "d")
   public void testGetMayNotReturnNullUnlessNoCreationalContextOrContextualCreateReturnsNull()
   {
      // The case of no creational context is already tested where a null is
      // returned. Here we just test that the contextual create can return null.
      MyContextual bean = new MyContextual(getCurrentManager());
      bean.setShouldReturnNullInstances(true);
      getCurrentManager().addBean(bean);

      CreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      assert getCurrentManager().getContext(SessionScoped.class).get(bean, myCreationalContext) == null;
      assert bean.isCreateCalled();
   }

   @Test(groups = { "contexts" })
   @SpecAssertions( { 
      @SpecAssertion(section = "6", id = "i"),
      @SpecAssertion(section = "6", id = "j"),
      @SpecAssertion(section = "8.1", id = "f"),
      @SpecAssertion(section = "8.2", id = "d")
   })
   public void testContextDestroysBeansWhenDestroyed()
   {
      MyContextual bean = new MyContextual(getCurrentManager());
      bean.setShouldReturnNullInstances(false);
      getCurrentManager().addBean(bean);

      CreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      Context sessionContext = getCurrentManager().getContext(SessionScoped.class);
      assert sessionContext.get(bean, myCreationalContext) != null;
      assert bean.isCreateCalled();
      
      destroyContext(sessionContext);
      assert bean.isDestroyCalled();
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertions( { 
      @SpecAssertion(section = "8.2", id = "e")
   })
   public void testSameNormalScopeBeanInjectedEverywhere()
   {
      SimpleBeanA instanceOfA = getCurrentManager().getInstanceByType(SimpleBeanA.class);
      SimpleBeanB instanceOfB = getCurrentManager().getInstanceByType(SimpleBeanB.class);
      assert instanceOfA.getZ() == instanceOfB.getZ();
   }
}
