package org.jboss.jsr299.tck.tests.context.application;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.war.WarArtifactDescriptor;
import org.testng.annotations.Test;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;

/**
 * 
 * @author David Allen
 *
 * Spec version: PRD2
 */
@Artifact
@IntegrationTest(runLocally=true)
@Resources({
  @Resource(destination=WarArtifactDescriptor.WEB_XML_DESTINATION, source="web.xml"),
  @Resource(destination="SimplePage.html", source="SimplePage.html")
})
public class ApplicationContextTest extends AbstractJSR299Test
{

   @Test(groups = { "contexts", "servlet", "integration" })
   @SpecAssertion(section = "8.5.3", id = "a")
   public void testApplicationScopeActiveDuringServiceMethod() throws Exception
   {
      WebClient webClient = new WebClient();
      webClient.setThrowExceptionOnFailingStatusCode(true);
      webClient.getPage(getContextPath() + "serviceMethodTest");
   }

   @Test(groups = { "contexts", "servlet", "integration" })
   @SpecAssertion(section = "8.5.3", id = "b")
   public void testApplicationScopeActiveDuringDoFilterMethod() throws Exception
   {
      WebClient webClient = new WebClient();
      webClient.setThrowExceptionOnFailingStatusCode(true);
      webClient.getPage(getContextPath() + "SimplePage.html");
   }

   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.3", id = "e")
   public void testApplicationScopeActiveDuringRemoteMethodInvocationOfEjb()
   {
      //TODO Easy to implement once global naming w/EJB3.1 is available
      assert false;
   }

   @Test(groups = { "stub", "contexts", "ejb3", "jms", "integration" })
   @SpecAssertion(section = "8.5.3", id = "g")
   public void testApplicationScopeActiveDuringMdbMessageDelivery()
   {
      assert false;
   }

   @Test(groups = { "contexts", "integration" })
   @SpecAssertion(section = "8.5.3", id = "h")
   public void testApplicationContextSharedBetweenServletRequests() throws Exception
   {
      WebClient webClient = new WebClient();
      webClient.setThrowExceptionOnFailingStatusCode(true);
      TextPage firstRequestResult = webClient.getPage(getContextPath() + "IntrospectApplication");
      assert firstRequestResult.getContent() != null;
      assert Double.parseDouble(firstRequestResult.getContent()) != 0;
      // Make a second request and make sure the same context is used
      TextPage secondRequestResult = webClient.getPage(getContextPath() + "IntrospectApplication");
      assert secondRequestResult.getContent() != null;
      assert Double.parseDouble(secondRequestResult.getContent()) == Double.parseDouble(firstRequestResult.getContent());
   }

   @Test(groups = { "stub", "contexts", "webservice", "integration" })
   @SpecAssertion(section = "8.5.3", id = "j")
   public void testApplicationContextSharedBetweenWebServices()
   {
      assert false;
   }

   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.3", id = "k")
   public void testApplicationContextSharedBetweenRemoteMethodInvokations()
   {
      //TODO Easy to implement once global naming w/EJB3.1 is available
      assert false;
   }

   @Test(groups = { "stub", "contexts", "jms", "integration" })
   @SpecAssertion(section = "8.5.3", id = "m")
   public void testApplicationContextSharedBetweenMDBMessageDeliveries()
   {
      assert false;
   }

   @Test(groups = { "underInvestigation", "contexts", "integration" })
   @SpecAssertion(section = "8.5.3", id = "n")
   public void testApplicationScopeDestroyedWhenApplicationIsUndeployed()
   {
      //TODO How can the WB container be tested after the app is undeployed?
      assert false;
   }

}
