package org.jboss.jsr299.tck.tests.context.application.ejb;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * EJB and related tests with the built-in application context.
 * 
 * @author David Allen
 *
 * Spec version: PRD2
 */
@Artifact
@IntegrationTest
@Packaging(PackagingType.EAR)
public class EJBApplicationContextTest extends AbstractJSR299Test
{
   @Test(groups = { "broken", "contexts", "webservice", "integration" })
   @SpecAssertion(section = "8.5.3", id = "c")
   public void testApplicationScopeActiveDuringWebSericeInvocation()
   {
      //TODO This test might work better with a separate client over HTTP
      FeederService birdFeeder = getCurrentManager().getInstanceByType(FeederService.class);
      Bird bird = getCurrentManager().getInstanceByType(Bird.class);
      bird.eat();
      assert birdFeeder.adequateFood();
   }

   @Test(groups = { "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.3", id = "f")
   public void testApplicationScopeActiveDuringCallToEjbTimeoutMethod() throws Exception
   {
      FMS flightManagementSystem = getCurrentManager().getInstanceByType(FMS.class);
      flightManagementSystem.climb();
      Thread.sleep(250);
      assert flightManagementSystem.isApplicationScopeActive();
   }

   @Test(groups = { "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.3", id = "l")
   public void testApplicationContextSharedBetweenEJBTimeoutInvokations() throws Exception
   {
      FMS flightManagementSystem = getCurrentManager().getInstanceByType(FMS.class);
      flightManagementSystem.climb();
      flightManagementSystem.descend();
      Thread.sleep(250);
      assert flightManagementSystem.isSameBean();
   }

}
