package org.jboss.jsr299.tck.tests.context.conversation.client;

import org.apache.commons.httpclient.HttpClient;
import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.war.WarArtifactDescriptor;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
@Artifact(addCurrentPackage=false)
@Classes({Storm.class, ConversationTestPhaseListener.class, ConversationStatusServlet.class, Cloud.class, CloudController.class})
@IntegrationTest(runLocally=true)
@Resources({
  @Resource(destination=WarArtifactDescriptor.WEB_XML_DESTINATION, source="web.xml"),
  @Resource(destination="home.jspx", source="home.jsf"),
  @Resource(destination="cloud.jspx", source="cloud.jsf"),
  @Resource(destination="clouds.jspx", source="clouds.jsf"),
  @Resource(destination="/WEB-INF/faces-config.xml", source="faces-config.xml"),
  @Resource(destination="rain.jspx", source="rain.jsf")
})
public class ClientConversationContextTest extends AbstractConversationTest
{
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "hb")
   public void testConversationIdSetByContainerIsUnique() throws Exception
   {
      HttpClient client = new HttpClient();
      request(client, "/home.jsf");
      String cid1 = getCid(client);
      request(client, "/home.jsf");
      String cid2 = getCid(client);
      assert !cid1.equals(cid2);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "j")
   public void testTransientConversationInstancesDestroyedAtRequestEnd() throws Exception
   {
      HttpClient client = new HttpClient();
      resetCloud(client);
      request(client, "/cloud.jsf");
      assert isCloudDestroyed(client);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "k")
   public void testLongRunningConversationInstancesNotDestroyedAtRequestEnd() throws Exception
   {
      HttpClient client = new HttpClient();
      resetCloud(client);
      request(client, "/clouds.jsf");
      assert !isCloudDestroyed(client);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "n")
   public void testManualCidPropagation() throws Exception
   {
      HttpClient client = new HttpClient();
      String cid = request(client, "/clouds.jsf");
      String cid2 = request(client, "/clouds.jsf?cid=" + cid);
      assert cid.equals(cid2);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "o")
   public void testConversationNotPropagated() throws Exception
   {
      HttpClient client = new HttpClient();
      String cid = request(client, "/clouds.jsf");
      String cid2 = request(client, "/clouds.jsf");
      assert !cid.equals(cid2);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "p")
   public void testConversationsDontCrossSessionBoundary() throws Exception
   {
      HttpClient client = new HttpClient();
      String cid = request(client, "/rain.jsf");
      assert hasRained(client, "/cloud.jsf?cid=" + cid);
      invalidateSession(client);
      assert !hasRained(client, "/cloud.jsf?cid=" + cid);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "b")
   public void testConversationActiveDuringNonFacesRequest() throws Exception
   {
      HttpClient client = new HttpClient();
      assert getBodyAsString(client, "/cloud.jsf").contains(Cloud.NAME);
   }
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "s")
   public void testConversationPropagationToNonExistentConversationLeadsToTransientConversation() throws Exception
   {
      HttpClient client = new HttpClient();
      assert !request(client, "/cloud.jsf?cid=org.jboss.jsr299").equals("org.jboss.jsr299");
   }

}