package org.jboss.jsr299.tck.tests.context.dependent;

import javax.annotation.Named;
import javax.annotation.PreDestroy;
import javax.context.Dependent;

@Dependent @Named
class Fox
{
   
   private static boolean destroyed = false;
   
   private static int destroyCount = 0;
   
   public static boolean isDestroyed()
   {
      return destroyed;
   }
   
   public static void setDestroyed(boolean destroyed)
   {
      Fox.destroyed = destroyed;
   }
   
   public static void setDestroyCount(int destroyCount)
   {
      Fox.destroyCount = destroyCount;
   }
   
   public static int getDestroyCount()
   {
      return destroyCount;
   }
   
   @PreDestroy
   public void destroy()
   {
      destroyed = true;
      destroyCount++;
   }
   
   public String getName()
   {
      return "gavin";
   }
   
}
