package org.jboss.jsr299.tck.tests.context.dependent;

import javax.annotation.Named;
import javax.context.Dependent;
import javax.inject.manager.Manager;

@Dependent
@Named
public class SensitiveFox
{
   private static Manager manager;

   private boolean dependentContextActiveDuringCreate = false;
   
   private static boolean dependentContextActiveDuringEval = false;

   public SensitiveFox()
   {
      if (manager.getContext(Dependent.class).isActive())
      {
         dependentContextActiveDuringCreate = true;
      }
   }

   public String getName()
   {
      if (manager.getContext(Dependent.class).isActive())
      {
         dependentContextActiveDuringEval = true;
      }
      return "gavin";
   }

   public boolean isDependentContextActiveDuringCreate()
   {
      return dependentContextActiveDuringCreate;
   }

   public static boolean isDependentContextActiveDuringEval()
   {
      return dependentContextActiveDuringEval;
   }

   public static void setManager(Manager manager)
   {
      SensitiveFox.manager = manager;
   }

}
