package org.jboss.jsr299.tck.tests.context.dependent;

import org.jboss.jsr299.tck.impl.JSR299ConfigurationImpl;

class Tarantula extends Spider implements DeadlySpider
{

   private static boolean dependentContextActive = false;
   
   public Tarantula()
   {
      dependentContextActive = JSR299ConfigurationImpl.get().getContexts().getDependentContext().isActive();
   }
   
   public static boolean isDependentContextActive()
   {
      return dependentContextActive;
   }
   
   public static void setDependentContextActive(boolean dependentContextActive)
   {
      Tarantula.dependentContextActive = dependentContextActive;
   }
   
   
}
