/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.context.request.standalone;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * @author David Allen
 *
 * Spec version: PRD2
 *
 */
@Artifact
public class RequestContextTest extends AbstractJSR299Test
{
   /**
    * The request scope is active during any asynchronous observer method notification
    */
   @Test(groups = { "contexts", "integration" })
   @SpecAssertion(section = "8.5.1", id = "f")
   public void testRequestScopeIsActiveDuringAsynchronousObserverMethodInvocation() throws Exception
   {
      getCurrentManager().fireEvent(new TargetEvent());
      Thread.sleep(200);
      assert TcasDisplay.isRequestScopeActive();
   }

   /**
    * The request context is destroyed after the asynchronous observer method notification
    * completes
    */
   @Test(groups = { "contexts", "integration" })
   @SpecAssertion(section = "8.5.1", id = "g")
   public void testRequestScopeIsDestroyedAfterAsynchronousObserverMethodInvocation() throws Exception
   {
      NearMiss event = new NearMiss();
      getCurrentManager().fireEvent(event);
      Thread.sleep(200);
      getCurrentManager().fireEvent(event);
      Thread.sleep(200);
      assert !event.isSameBean();
   }

}
