package org.jboss.jsr299.tck.tests.context.request.standalone;

import javax.context.RequestScoped;
import javax.event.Asynchronously;
import javax.event.Observes;
import javax.inject.Current;
import javax.inject.manager.Manager;

class TcasDisplay
{
   @Current
   private Manager manager;
   
   private static boolean requestScopeActive = false;
   
   public void drawTarget(@Observes @Asynchronously TargetEvent targetEvent)
   {
      if (manager.getContext(RequestScoped.class).isActive())
      {
         requestScopeActive = true;
      }
      else
      {
         requestScopeActive = false;
      }
   }

   public void drawNearMiss(@Observes @Asynchronously NearMiss event)
   {
      event.setBean(manager.getInstanceByType(SimpleRequestBean.class));
   }

   public static boolean isRequestScopeActive()
   {
      return requestScopeActive;
   }

   public static void setRequestScopeActive(boolean requestScopeActive)
   {
      TcasDisplay.requestScopeActive = requestScopeActive;
   }
}
