package org.jboss.jsr299.tck.tests.context.session;

import java.io.IOException;

import javax.context.SessionScoped;
import javax.inject.Current;
import javax.inject.manager.Manager;
import javax.naming.InitialContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterTest implements Filter
{
   @Current
   private Manager jsr299Manager;

   public void destroy()
   {
      jsr299Manager = null;
   }

   public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
   {
      if (!jsr299Manager.getContext(SessionScoped.class).isActive())
      {
         throw new ServletException("Session is not active");
      }
      else
      {
         chain.doFilter(request, response);
      }
   }

   public void init(FilterConfig filterConfig) throws ServletException
   {
      //TODO Remove init code once injection works in servlet container
      try
      {
         if (jsr299Manager == null)
         {
            InitialContext ic = new InitialContext();
            jsr299Manager = (Manager) ic.lookup("java:app/Manager");
         }
      }
      catch (Exception e)
      {
         throw new ServletException("Error looking up manager", e);
      }
   }

}
