package org.jboss.jsr299.tck.tests.context.session;

import java.io.IOException;

import javax.inject.Current;
import javax.inject.manager.Manager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InvalidateSession extends HttpServlet
{
   private static final long serialVersionUID = 1L;

   @Current
   private Manager jsr299Manager;

   @Override
   protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
   {
      resp.setContentType("text/text");
      
      if (req.getParameter("timeout") != null)
      {
         SimpleSessionBean.setBeanDestroyed(false);
         jsr299Manager.getInstanceByType(SimpleSessionBean.class);
         req.getSession().setMaxInactiveInterval(Integer.parseInt(req.getParameter("timeout")));
      }
      else if (req.getParameter("isBeanDestroyed") != null)
      {
         resp.getWriter().print(SimpleSessionBean.isBeanDestroyed());
      }
      else
      {
         SimpleSessionBean.setBeanDestroyed(false);
         jsr299Manager.getInstanceByType(SimpleSessionBean.class);
         req.getSession().invalidate();
      }
   }

   @Override
   public void init() throws ServletException
   {
      //TODO Remove init code once injection works in servlet container
      try
      {
         InitialContext ic = new InitialContext();
         jsr299Manager = (Manager) ic.lookup("java:app/Manager");
      }
      catch (NamingException e)
      {
         throw new ServletException("Error looking up manager", e);
      }
   }

   @Override
   public void init(ServletConfig config) throws ServletException
   {
      init();
   }
}
