package org.jboss.jsr299.tck.tests.definition.binding;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.Production;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 */
@Artifact
public class BindingDefinitionTest extends AbstractJSR299Test
{

   @Test
   @SpecAssertion(section = "2.3.1", id = "a") 
   public void testDefaultBindingDeclaredInJava()
   {
      Bean<Order> order = getCurrentManager().resolveByType(Order.class).iterator().next();
      assert order.getBindings().size() == 1;
      order.getBindings().iterator().next().annotationType().equals(Production.class);
   }
   
   @Test
   @SpecAssertion(section = "2.3.1", id = "b")
   public void testDefaultBindingForInjectionPoint()
   {
      Bean<Order> order = getCurrentManager().resolveByType(Order.class).iterator().next();     
      InjectionPoint injectionPoint = order.getInjectionPoints().iterator().next();
      assert injectionPoint.getBean().getBindings().iterator().next().annotationType().equals(Current.class);
   }

   @Test(groups = { "annotationDefinition" })
   @SpecAssertion(section = "2.3.2", id = "b")
   public void testBindingDeclaresBindingAnnotation()
   {
      assert !getCurrentManager().resolveByType(Tarantula.class, new TameBinding()).isEmpty();
   }

   @Test
   @SpecAssertion(section = "2.3.3", id = "a")
   public void testBindingsDeclaredInJava()
   {
      Bean<Cat> cat = getCurrentManager().resolveByType(Cat.class, new SynchronousBinding()).iterator().next();
      assert cat.getBindings().size() == 1;
      assert cat.getBindings().contains(new SynchronousBinding());
   }

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "2.3.3", id = "b"),
      @SpecAssertion(section = "3.2.3", id = "be")
   })
   public void testMultipleBindings()
   {
      Bean<?> model = getCurrentManager().resolveByType(Cod.class, new ChunkyBinding(true), new WhitefishBinding()).iterator().next();
      assert model.getBindings().size() == 2;
   }

   @Test(groups = { "injection", "producerMethod" })
   @SpecAssertion(section = "2.3.5", id = "a")
   public void testFieldInjectedFromProducerMethod() throws Exception
   {
      Barn barn = getCurrentManager().resolveByType(Barn.class).iterator().next().create(new MockCreationalContext<Barn>());
      assert barn.petSpider != null;
      assert barn.petSpider instanceof DefangedTarantula;
   }

   @Test(groups = { "injection", "producerMethod" })
   @SpecAssertion(section = "unknown", id = "unknown")
   public void testMethodWithBindingAnnotationsOnParametersAreInjected() throws Exception
   {
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            Spider spider = getCurrentManager().getInstanceByType(Spider.class, new AnnotationLiteral<Produced>() {});
            assert spider != null;
            assert spider instanceof DefangedTarantula;
         }
         
      }.run();
         
         
   }

   @Test
   @SpecAssertion(section = "4.1", id = "aa")
   public void testBindingDeclaredInheritedIsInherited() throws Exception
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(BorderCollie.class, new HairyBinding(false)).iterator().next().getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Hairy.class);
   }

   @Test
   @SpecAssertion(section = "4.1", id = "aa")
   public void testBindingNotDeclaredInheritedIsNotInherited()
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(ShetlandPony.class).iterator().next().getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Current.class);
   }

   @Test
   @SpecAssertion(section = "4.1", id = "aa")
   public void testBindingDeclaredInheritedIsBlockedByIntermediateClass()
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(ClippedBorderCollie.class, new HairyBinding(true)).iterator().next().getBindings();
      assert bindings.size() == 1;
      Annotation binding = bindings.iterator().next();
      assert binding.annotationType().equals(Hairy.class);
      Hairy hairy = (Hairy) binding;
      assert hairy.clipped();
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "ag")
   public void testBindingDeclaredInheritedIsIndirectlyInherited()
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(EnglishBorderCollie.class, new HairyBinding(false)).iterator().next().getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Hairy.class);
   }

}