package org.jboss.jsr299.tck.tests.definition.binding.enterprise;

import java.lang.annotation.Annotation;
import java.util.Set;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

@Artifact
@IntegrationTest
@Packaging(PackagingType.EAR)
public class EnterpriseBindingDefinitionTest extends AbstractJSR299Test
{
   @Test
   @SpecAssertion(section = "4.1", id = "ad")
   public void testBindingDeclaredInheritedIsInherited() throws Exception
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(BorderCollieLocal.class, new HairyBinding(false)).iterator().next().getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Hairy.class);
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "aj")
   public void testBindingDeclaredInheritedIsIndirectlyInherited()
   {
      Set<? extends Annotation> bindings = getCurrentManager().resolveByType(EnglishBorderCollieLocal.class, new HairyBinding(false)).iterator().next().getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Hairy.class);
   }   
}
