package org.jboss.jsr299.tck.tests.definition.deployment.enterprise;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@IntegrationTest
@Artifact
@Packaging(PackagingType.EAR)
@BeansXml("beans.xml")
public class EnterpriseDeploymentTypeDefinitionTest extends AbstractJSR299Test
{
   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "cb")
   public void testDeploymentTypeDeclaredInheritedIsInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(BorderCollieLocal.class, new WoofBinding()).size() == 1;
      assert getCurrentManager().resolveByType(BorderCollieLocal.class, new WoofBinding()).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }
   
   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "cd")
   public void testDeploymentTypeDeclaredInheritedIsIndirectlyInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(EnglishBorderCollieLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(EnglishBorderCollieLocal.class).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }   
   
   @Test
   @SpecAssertion(section = "4.1", id = "dbb")
   public void testDeploymentTypeIsOverriddenByInheritedDeploymentType()
   {
      assert getCurrentManager().resolveByType(CowLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(CowLocal.class).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);      
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "ddb")
   public void testDeploymentTypeIsOverriddenByIndirectlyInheritedDeploymentType()
   {
      assert getCurrentManager().resolveByType(JerseyBullLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(JerseyBullLocal.class).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);      
   }     
}
