package org.jboss.jsr299.tck.tests.definition.stereotype.enterprise;

import javax.context.RequestScoped;
import javax.context.SessionScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
@IntegrationTest
@Artifact
@Packaging(PackagingType.EAR)
public class EnterpriseStereotypeDefinitionTest extends AbstractJSR299Test
{
   @Test
   @SpecAssertion(section = "4.1", id = "ae")
   public void testStereotypeDeclaredInheritedIsInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(BorderCollieLocal.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "ak")
   public void testStereotypeDeclaredInheritedIsIndirectlyInherited()
   {
      assert getCurrentManager().resolveByType(EnglishBorderCollieLocal.class).iterator().next().getScopeType().equals(RequestScoped.class);      
   }   
   
   @Test
   @SpecAssertion(section = "4.1", id = "dba")
   public void testStereotypeScopeIsOverriddenByInheritedScope()
   {
      assert getCurrentManager().resolveByType(ChihuahuaLocal.class).iterator().next().getScopeType().equals(SessionScoped.class);      
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "dda")
   public void testStereotypeScopeIsOverriddenByIndirectlyInheritedScope()
   {
      assert getCurrentManager().resolveByType(MexicanChihuahuaLocal.class).iterator().next().getScopeType().equals(SessionScoped.class);      
   }    
}
