/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.event.broken.jms1;

import javax.inject.DefinitionException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ExpectedDeploymentException;
import org.testng.annotations.Test;

/**
 * Tests that observers of mapped event types to JMS are asynchronous observers;
 * otherwise, an exception is thrown.
 * 
 * @author David Allen
 *
 */
@Artifact
@ExpectedDeploymentException(DefinitionException.class)
public class MappedEventObserversAsynchronousTest
{
   @Test(groups = { "events", "stub" })
   @SpecAssertion(section = "7.8", id = "c")
   public void testObserverOfMappedTypeMustBeAsynchronous() throws Exception
   {
      assert false;
   }

}
