package org.jboss.jsr299.tck.tests.event.enterprise;

import java.util.Set;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * Tests for event inheritence with enterprise beans
 * 
 * @author Shane Bryzak
 */
@Artifact
@Packaging(PackagingType.EAR)
@IntegrationTest
public class EnterpriseEventInheritenceTest extends AbstractJSR299Test
{
   @Test(groups = { "events", "inheritance" })
   @SpecAssertion(section = "4.2", id = "df")
   public void testNonStaticObserverMethodNotInherited() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Set<Observer<Egg>> observers = getCurrentManager().resolveObservers(new Egg());
            assert observers.size() == 1;

            // Notify the observer so we can confirm that it
            // is a method only on Farmer, and not LazyFarmer
            observers.iterator().next().notify(new Egg());
            assert Farmer.getObserverClazz().equals(Farmer.class);
         }

      }.run();
   }
   
   @Test(groups = { "events", "inheritance" })
   @SpecAssertion(section = "4.2", id = "dl")
   public void testNonStaticObserverMethodNotIndirectlyInherited() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Set<Observer<StockPrice>> observers = getCurrentManager().resolveObservers(new StockPrice());
            assert observers.size() == 1;

            // Notify the observer so we can confirm that it
            // is a method only on StockWatcher, and not IndirectStockWatcher
            observers.iterator().next().notify(new StockPrice());
            assert StockWatcher.getObserverClazz().equals(StockWatcher.class);
         }

      }.run();
   }  
}
