package org.jboss.jsr299.tck.tests.event.register.observer1;

import javax.event.Observer;
import javax.inject.DuplicateBindingTypeException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class DuplicateBindingsToAddObserverTest extends AbstractJSR299Test
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" }, expectedExceptions = { DuplicateBindingTypeException.class })
   @SpecAssertion(section = "7.3", id = "j")
   public void testMultipleInstancesOfSameBindingTypeWhenAddingObserverFails()
   {
      Observer<AnEventType> observer = new AnObserver();
      getCurrentManager().addObserver(observer, AnEventType.class, new RoleBinding("Admin"), new TameAnnotationLiteral(), new TameAnnotationLiteral());
   }
}
