package org.jboss.jsr299.tck.tests.event.register.observer1;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ObserverExceptionAbortsTest extends AbstractJSR299Test
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   public static class AnObserverWithException implements Observer<AnEventType>
   {
      public boolean wasNotified = false;
      public RuntimeException theException = new RuntimeException("RE1");

      public void notify(AnEventType event)
      {
         wasNotified = true;
         throw theException;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertion(section = "7.4", id = "c")
   public void testObserverThrowsExceptionAbortsNotifications()
   {
      AnObserverWithException observer = new AnObserverWithException();
      AnObserverWithException anotherObserver = new AnObserverWithException();
      getCurrentManager().addObserver(anotherObserver, AnEventType.class);
      getCurrentManager().addObserver(observer, AnEventType.class);

      // Fire an event that will be delivered to the two above observers
      AnEventType anEvent = new AnEventType();
      boolean fireFailed = false;
      try
      {
         getCurrentManager().fireEvent(anEvent);
      }
      catch (Exception e)
      {
         if (e.equals(observer.theException) || e.equals(anotherObserver.theException))
            fireFailed = true;
      }
      assert fireFailed;
      // Only one of the observers can be notified if processing
      // is aborted
      assert observer.wasNotified ^ anotherObserver.wasNotified;
   }
}
