package org.jboss.jsr299.tck.tests.event.resolve.nonbinding;

import java.util.Set;

import javax.event.Observer;
import javax.inject.TypeLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class NonBindingTypesWhenResolvingTest extends AbstractJSR299Test
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" }, expectedExceptions = { IllegalArgumentException.class })
   @SpecAssertion(section = "7.7", id = "e")
   public void testNonBindingTypeAnnotationWhenResolvingFails()
   {
      AnObserver observer = new AnObserver();
      getCurrentManager().addObserver(observer, new TypeLiteral<AnEventType>()
      {
      });
      Set<Observer<AnEventType>> resolvedObservers = getCurrentManager().resolveObservers(new AnEventType(), new AnimalStereotypeAnnotationLiteral());
      assert !resolvedObservers.isEmpty();
   }
}
