package org.jboss.jsr299.tck.tests.event.resolve.type;

import java.util.ArrayList;

import javax.event.Observer;
import javax.inject.TypeLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ChecksTypeParametersWhenResolvingTest extends AbstractJSR299Test
{
   
   public static class AList extends ArrayList<String>
   {
      
   }
   
   public static class AnotherList extends ArrayList<Integer>
   {
      
   }
   
   public static class AListObserver implements Observer<ArrayList<String>>
   {
      public boolean wasNotified = false;

      public void notify(ArrayList<String> event)
      {
         wasNotified = true;
      }
   }

   public static class AnotherListObserver implements Observer<ArrayList<Integer>>
   {
      public boolean wasNotified = false;

      public void notify(ArrayList<Integer> event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertion(section = "7.7", id = "f")
   public void testResolvingChecksTypeParameters()
   {
      AListObserver observer = new AListObserver();
      AnotherListObserver anotherObserver = new AnotherListObserver();
      getCurrentManager().addObserver(observer, new TypeLiteral<ArrayList<String>>()
      {
      });
      getCurrentManager().addObserver(anotherObserver, new TypeLiteral<ArrayList<Integer>>()
      {
      });
      assert getCurrentManager().resolveObservers(new AList()).size() == 1;
      assert getCurrentManager().resolveObservers(new AList()).iterator().next().getClass().equals(AListObserver.class);
   }
   
   @Test(groups = { "events" })
   @SpecAssertion(section = "7.7", id = "f")
   public void testResolvingChecksTypeParametersOnObservesMethod()
   {
      Foo<String> fooEvent = new Foo<String>() {};
      getCurrentManager().fireEvent(fooEvent);
      assert fooEvent.isObserved();
   }
}
