package org.jboss.jsr299.tck.tests.event.transactionalObservers;

import static javax.ejb.TransactionManagementType.BEAN;

import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.event.BeforeTransactionCompletion;
import javax.event.Observes;
import javax.transaction.UserTransaction;

@Stateless
@TransactionManagement(BEAN)
public class DogTrainer implements Trainer
{
   @Resource
   private UserTransaction userTransaction;

   public void train(@Observes @BeforeTransactionCompletion DisobedientDog dog)
   {
      try
      {
         userTransaction.setRollbackOnly();
      }
      catch (Exception e)
      {
         throw new EJBException("Failed to set transaction rollback only", e);
      }
   }

   public void trainNewTricks(@Observes @BeforeTransactionCompletion ShowDog dog)
   {
      try
      {
         userTransaction.begin();
         userTransaction.rollback();
      }
      catch (Exception e)
      {
         throw new EJBException("Failed to start new transaction", e);
      }
   }

   public void trainCompanion(@Observes @BeforeTransactionCompletion SmallDog dog)
   {
      try
      {
         userTransaction.rollback();
      }
      catch (Exception e)
      {
         throw new EJBException("Failed to start new transaction", e);
      }
   }

   public void trainSightSeeing(@Observes @BeforeTransactionCompletion LargeDog dog)
   {
      try
      {
         userTransaction.commit();
      }
      catch (Exception e)
      {
         throw new EJBException("Failed to start new transaction", e);
      }
   }

}
