package org.jboss.jsr299.tck.tests.implementation.enterprise.newBean;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.context.Dependent;
import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.DefinitionException;
import javax.inject.New;
import javax.inject.Standard;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.literals.NewLiteral;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
@Packaging(PackagingType.EAR)
public class NewEnterpriseBeanTest extends AbstractJSR299Test
{
   private Bean<WrappedEnterpriseBeanLocal> newEnterpriseBean;
   
   private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>() {};
   
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6", id = "d")
   public void testNewBeanIsDependentScoped()
   {
      Set<Bean<WrappedEnterpriseBeanLocal>> beans = getCurrentManager().resolveByType(WrappedEnterpriseBeanLocal.class, new NewLiteral());
      assert beans.size() == 1;
      newEnterpriseBean = beans.iterator().next();
      assert Dependent.class.equals(newEnterpriseBean.getScopeType());
   }

   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6", id = "e")
   public void testNewBeanIsOfStandardDeploymentType()
   {
      Set<Bean<WrappedEnterpriseBeanLocal>> beans = getCurrentManager().resolveByType(WrappedEnterpriseBeanLocal.class, new NewLiteral());
      assert beans.size() == 1;
      newEnterpriseBean = beans.iterator().next();
      assert Standard.class.equals(newEnterpriseBean.getDeploymentType());
   }

   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6", id = "f")
   public void testNewBeanIsHasOnlyNewBinding()
   {
      Set<Bean<WrappedEnterpriseBeanLocal>> beans = getCurrentManager().resolveByType(WrappedEnterpriseBeanLocal.class, new NewLiteral());
      assert beans.size() == 1;
      newEnterpriseBean = beans.iterator().next();
      assert newEnterpriseBean.getBindings().size() == 1;
      assert newEnterpriseBean.getBindings().iterator().next().annotationType().equals(new NewLiteral().annotationType());
   }

   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6", id = "g")
   public void testNewBeanHasNoWebBeanName()
   {
      Set<Bean<WrappedEnterpriseBeanLocal>> beans = getCurrentManager().resolveByType(WrappedEnterpriseBeanLocal.class, new NewLiteral());
      assert beans.size() == 1;
      newEnterpriseBean = beans.iterator().next();
      assert newEnterpriseBean.getName() == null;
   }

   @Test(groups = { "stub", "new"})
   @SpecAssertion(section = "3.3.6", id = "h")
   public void testNewBeanHasNoStereotypes()
   {
      assert false;
   }
   
   @Test(groups = {"new" })
   @SpecAssertion(section = "3.3.6", id = "i")
   public void testNewBeanHasNoObservers()
   {
      // Should just be 1 observer from bean, not new bean
      assert getCurrentManager().resolveObservers("event").size() == 1;
   }

   @Test(groups = { "new", "stub", "underInvestigation" })
   @SpecAssertion(section = "3.3.6", id = "k")
   public void testNewBeanHasNoProducerFields()
   {
      assert false;
   }

   /**
    * 
    * TODO There really is no way to prove that a @New bean has no producers
    * 
    * PLM - Make sure that there is no ambiguous dependency exception when resolving it - if the @New bean did have a producer method you would get one (I think?!) 
    */
   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.3.6", id = "j")
   public void testNewBeanHasNoProducerMethods()
   {
      assert false;
   }

   @Test(groups = { "new", "stub", "disposal" })
   @SpecAssertion(section = "3.3.6", id = "l")
   public void testNewBeanHasNoDisposalMethods()
   {
      assert false;
   }

   /**
    * If the @New binding type appears in conjunction with some other binding
    * type, or is specified for a field or parameter of a type which does not
    * satisfy the definition of a simple Web Bean implementation class or
    * enterprise Web Bean implementation class, a DefinitionException is thrown
    * by the container at deployment time.
    */
   @Test(groups = { "stub", "new" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "review", id = "review")
   public void testNewAnnotationCannotBeAppliedToNonWebBeanImplementationClass()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="3.3.6", id = "aa")
   public void testForEachEnterpriseBeanANewBeanExists()
   {
      assert getCurrentManager().resolveByType(OrderLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(OrderLocal.class).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(OrderLocal.class).iterator().next().getBindings().iterator().next().annotationType().equals(Current.class);
      
      assert getCurrentManager().resolveByType(OrderLocal.class, new NewLiteral()).size() == 1;
      assert getCurrentManager().resolveByType(OrderLocal.class, new NewLiteral()).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(OrderLocal.class, new NewLiteral()).iterator().next().getBindings().iterator().next().annotationType().equals(New.class);
      
      assert getCurrentManager().resolveByType(LionLocal.class, TAME_LITERAL).size() == 1;
      assert getCurrentManager().resolveByType(LionLocal.class, TAME_LITERAL).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(LionLocal.class, TAME_LITERAL).iterator().next().getBindings().iterator().next().annotationType().equals(Tame.class);
      
      assert getCurrentManager().resolveByType(LionLocal.class, new NewLiteral()).size() == 1;
      assert getCurrentManager().resolveByType(LionLocal.class, new NewLiteral()).iterator().next().getBindings().size() == 1;
      assert getCurrentManager().resolveByType(LionLocal.class, new NewLiteral()).iterator().next().getBindings().iterator().next().annotationType().equals(New.class);
   }
   
}
