package org.jboss.jsr299.tck.tests.implementation.initializer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
@Artifact
@Packaging(PackagingType.EAR)
public class InitializerMethodTest extends AbstractJSR299Test
{

   @Test(groups = { "stub", "initializerMethod", "servlet", "integration" })
   @SpecAssertion(section = "3.9", id = "d")
   public void testInitializerMethodCalledOnServlet()
   {
      assert false;
   }

   @Test(groups = { "stub", "initializerMethod", "ejb3", "integration" })
   @SpecAssertion(section = "3.9", id = "d")
   public void testInitializerMethodCalledOnEJBSessionBean()
   {
      assert false;
   }

   @Test(groups = { "stub", "initializerMethod", "ejb3", "integration" })
   @SpecAssertion(section = "3.9", id = "d")
   public void testInitializerMethodCalledOnEJBMDB()
   {
      assert false;
   }

   @Test(groups = { "stub", "initializerMethod", "ejb3", "singletons", "integration" })
   @SpecAssertion(section = "3.9", id = "d")
   public void testInitializerMethodCalledOnEJBSingleton()
   {
      assert false;
   }

   @Test(groups = { "stub", "initializerMethod", "interceptors" })
   @SpecAssertion(section = "3.9", id = "f")
   public void testMethodInterceptorNotCalledOnInitializerMethod()
   {
      assert false;
   }

   @Test(groups = { "initializerMethod" })
   @SpecAssertions({ 
      @SpecAssertion(section = "3.9", id = "g"), 
      @SpecAssertion(section = "5.3", id = "b"),
      @SpecAssertion(section = "3.9.1", id = "a"),
      @SpecAssertion(section = "3.9.3", id = "a")
   })
   public void testMultipleInitializerMethodsAreCalled()
   {
      ChickenHutch chickenHutch = getCurrentManager().getInstanceByType(ChickenHutch.class);
      assert chickenHutch.fox != null;
      assert chickenHutch.chicken != null;
   }

}